<?php
/**
 * Enter description here ...
 *
 * @author Jianmin Chen <sky_hold@163.com>
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: UploadAvatarController.php 17046 2012-08-30 09:40:11Z xiaoxia.xuxx $
 * @package src.applications.windid.controller
 */
class UploadAvatarController extends PwBaseController {
	
	/* (non-PHPdoc)
	 * @see WindController::run()
	 * flash头像上传
	 */
	public function run() {
		$uid = $this->getInput('uid');
		Wind::import('SRV:upload.action.PwAvatarUpload');
		Wind::import('SRV:upload.PwUpload');
		$bhv = new PwAvatarUpload(new PwUserBo($uid));
		
		$upload = new PwUpload($bhv);
		if (($result = $upload->check()) === true) {
			$result = $upload->execute();
		}
		if ($result !== true) {
			$array = array(
				"isSuccess" => false, 
				"msg" => WindConvert::convert('上传失败', 'utf8', Wekit::app()->charset), 
				"erCode" => "000");
			//$this->showMessage($result->getMessage());
		} else {
			//用户上传头像之后的钩子
			PwSimpleHook::getInstance('update_avatar')->runDo($uid);
			$array = array(
				"isSuccess" => true, 
				"msg" => WindConvert::convert('上传成功', 'utf8', Wekit::app()->charset), 
				"erCode" => "000");
		}
		exit(WindJson::encode($array));
	}

	/**
	 * 普通头像上传
	 */
	public function nomalAction() {
		$uid = $this->getInput('uid');
		Wind::import('SRV:upload.action.PwAvatarUpload');
		Wind::import('SRV:upload.PwUpload');
		$bhv = new PwAvatarUpload(new PwUserBo($uid));
		
		$upload = new PwUpload($bhv);
		if (($result = $upload->check()) === true) {
			$result = $upload->execute();
		}
		if ($result instanceof PwError) {
			$this->showError($result->getError());
		} else {
			//用户上传头像之后的钩子
			PwSimpleHook::getInstance('update_avatar')->runDo($uid);
			$this->showMessage('upload.success');
		}
	}
}