<?php
Wind::import('APPS:admin.library.AdminBaseController');
Wind::import('SRC:extensions.album.service.bo.PwPhotoBo');
/**
 * 相册后台
 *
 * @author Shi Long <long.shi@alibaba-inc.com>
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: ManageController.php 17575 2012-09-06 10:44:25Z long.shi $
 * @package album.admin
 */
class ManageController extends AdminBaseController {

	private $perpage = 18;
	
	/* (non-PHPdoc)
	 * @see WindController::run()
	 */
	public function run() {
		$conf = Wekit::config('ALBUM');
		$conf['isopen'] = Wekit::config('site', 'album.isopen');
		$this->setOutput($conf, 'conf');
	}

	/**
	 * 保存相册设置
	 *
	 */
	public function doRunAction() {
		$conf = $this->getInput('conf');
		if (intval($conf['maxphoto']) > PwPhotoBo::MAX_PHOTO_NUM)
			$this->showError('PHOTO:album.photo.num');
		$bo = new PwConfigBo('ALBUM');
		$bo->set('maxalbum', $conf['maxalbum'])->set('maxphoto', 
			$conf['maxphoto']);
		$bo->flush();
		Wekit::load('config.PwConfig')->setConfig('SITE', 'album.isopen', $conf['isopen']);
		$this->showMessage('success');
	}

	/**
	 * 后台照片搜索
	 *
	 */
	public function searchAction() {
		list($album, $username, $name, $descrip, $mintime, $maxtime) = $this->getInput(
			array('album', 'username', 'name', 'descrip', 'mintime', 'maxtime'));
		Wind::import('SRC:extensions.album.service.so.PwPhotoSo');
		$so = new PwPhotoSo();
		$args = array();
		if ($album) {
			$so->setAlbumName($album);
			$args['album'] = $album;
		}
		if ($username) {
			$so->setCreatedUsername($username);
			$args['username'] = $username;
		}
		if ($name) {
			$so->setPhotoname($name);
			$args['name'] = $name;
		}
		if ($descrip) {
			$so->setDescrip($descrip);
			$args['descrip'] = $descrip;
		}
		if ($mintime) {
			$so->setMinUploadTime(Pw::str2time($mintime . ' 00:00'));
			$args['mintime'] = $mintime;
		}
		if ($maxtime) {
			$so->setMaxUploadTime(Pw::str2time($maxtime . ' 23:59'));
			$args['maxtime'] = $maxtime;
		}
		
		/* @var $srv PwPhotoJoin */
		$srv = Wekit::load('SRC:extensions.album.service.PwPhotoJoin');
		$count = $srv->countSearchPhoto($so);
		
		$page = intval($this->getInput('page'));
		$page < 1 && $page = 1;
		$photos = array();
		if ($count > 0) {
			list($start, $num) = Pw::page2limit($page, $this->perpage);
			$photos = $srv->searchPhoto($so, $num, $start);
		}
		
		$this->setOutput(array(
			'page' => $page,
			'perpage' => $this->perpage,
			'count' => $count,
			'photos' => $photos,
			'args' => http_build_query($args),
			'album' => $album,
			'username' => $username,
			'name' => $name,
			'descrip' => $descrip,
			'mintime' => $mintime,
			'maxtime' => $maxtime
		));
	}

		
	
	/**
	 * 删除照片
	 *
	 */
	public function doDelAction() {
		$photoids = $this->getInput('photoids');
		if (empty($photoids)) $this->showError('PHOTO:photoid.none');
		/* @var $srv PwAlbumService */
		$srv = Wekit::load('SRC:extensions.album.service.srv.PwAlbumService');
		foreach ($photoids as $photoid) {
			$bo = new PwPhotoBo($photoid);
			$r = $srv->deletePhoto($bo);
			if ($r instanceof PwError) $this->showError($r->getError());
		}
				
		$this->showMessage('success');
	}
	
	
}

?>