<?php
Wind::import('SRC:extensions.album.service.dm.PwAlbumDm');
Wind::import('SRC:extensions.album.service.PwAlbum');
/**
 * 相册
 *
 * @author Shi Long <long.shi@alibaba-inc.com>
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: IndexController.php 17612 2012-09-07 03:06:34Z long.shi $
 * @package album.controller
 */
class IndexController extends PwBaseController {
	
	public function beforeAction($handlerAdapter) {
		parent::beforeAction($handlerAdapter);
		if ($this->loginUser->uid < 1) $this->forwardRedirect(WindUrlHelper::createUrl('u/login/run'));
		if (!Wekit::config('SITE', 'album.isopen')) $this->showError('PHOTO:closed');
	}
	
	/* (non-PHPdoc)
	 * @see WindController::run()
	 */
	public function run() {
		$this->_albumService()->getDefaultAlbumidByType($this->loginUser->uid);
		$albums = $this->_albumDs()->getMyAlbums($this->loginUser->uid);
		$this->setOutput($albums, 'albums');
		// seo设置
		Wind::import('SRV:seo.bo.PwSeoBo');
		$lang = Wind::getComponent('i18n');
		PwSeoBo::setCustomSeo($lang->getMessage('PHOTO:album.album.run.title'), '', '');
	}
	
	/**
	 * 添加相册
	 *
	 */
	public function addAction() {
		$this->_checkAlbumNum();
	}
	
	/**
	 * 添加相册
	 *
	 */
	public function doAddAction() {
		$this->_checkAlbumNum();
		list($name, $descrip, $privacy) = $this->getInput(array('name', 'descrip', 'privacy'), 'post');
		$dm = new PwAlbumDm();
		$dm->setName($name)->setDescrip($descrip)->setPrivacy($privacy)->setCreatedUid($this->loginUser->uid);
		$r = $this->_albumDs()->addAlbum($dm);
		if ($r instanceof PwError) $this->showError($r->getError());
		$maxphoto = Wekit::config('ALBUM', 'maxphoto');
		$this->setOutput(array('albumid' => $r, 'name' => $name, 'num' => $maxphoto), 'data');
		$this->showMessage('success'); 
	}
	
	/**
	 * 编辑
	 *
	 */
	public function editAction() {
		$albumid = $this->getInput('albumid');
		$album = $this->_albumDs()->getAlbum($albumid);
		if (!$album) $this->showError('PHOTO:album.exist.fail');
		$this->setOutput($album, 'album');
	}
	
	/**
	 * 编辑
	 *
	 */
	public function doEditAction() {
		list($albumid, $name, $descrip, $privacy) = $this->getInput(array('albumid', 'name', 'descrip', 'privacy'), 'post');
		$album = $this->_albumDs()->getAlbum($albumid);
		if (!$album) $this->showError('PHOTO:album.exist.fail');
		if ($this->loginUser->uid != $album['created_uid']) $this->showError('PHOTO:album.manage.fail');
		$dm = new PwAlbumDm();
		$dm->setName($name)->setDescrip($descrip)->setPrivacy($privacy)->setAlbumid($albumid);
		$r = $this->_albumDs()->updateAlbum($dm);
		if ($r instanceof PwError) $this->showError($r->getError());
		$this->showMessage('success'); 
	}
	
	/**
	 * 删除相册
	 *
	 */
	public function delAction() {
		$albumid = intval($this->getInput('albumid'));
		$album = $this->_albumDs()->getAlbum($albumid);
		if (!$album) $this->showError('PHOTO:album.exist.fail');
		if ($this->loginUser->uid != $album['created_uid']) $this->showError('PHOTO:album.manage.fail');
		$r = $this->_albumService()->deleteAlbum($albumid);
		if (!$r) $this->showError('PHOTO:album.del.fail');
		$this->showMessage('success');
	}
	
	/**
	 * @return PwAlbum
	 */
	private function _albumDs() {
		return Wekit::load('SRC:extensions.album.service.PwAlbum');
	}
	
	/**
	 * @return PwAlbumService
	 */
	private function _albumService() {
		return Wekit::load('SRC:extensions.album.service.srv.PwAlbumService');
	}
	
	private function _checkAlbumNum() {
		$num = $this->_albumDs()->countByUidAndType($this->loginUser->uid, PwAlbumDm::ALBUM_TYPE_COMMON);
		if ($num >= Wekit::config('ALBUM', 'maxalbum')) $this->showError('PHOTO:album.num.limit');
	}
	
}

?>