<?php
Wind::import('SRC:extensions.album.service.dm.PwAlbumDm');
Wind::import('SRC:extensions.album.service.dm.PwPhotoDm');
Wind::import('SRC:extensions.album.service.bo.PwPhotoBo');

/**
 * 个人中心 - 照片
 *
 * @author Shi Long <long.shi@alibaba-inc.com>
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PhotoController.php 18231 2012-09-12 01:46:00Z long.shi $
 * @package album.controller
 */
class PhotoController extends PwBaseController {
	private $perpage = 24;

	public function beforeAction($handlerAdapter) {
		parent::beforeAction($handlerAdapter);
		if ($this->loginUser->uid < 1) $this->forwardRedirect(
			WindUrlHelper::createUrl('u/login/run'));
		if (!Wekit::config('SITE', 'album.isopen')) $this->showError('PHOTO:closed');
	}
	
	/*
	 * (non-PHPdoc) @see WindController::run()
	 */
	public function run() {
		$albumid = $this->getInput('albumid');
		$album = $this->_albumDs()->getAlbum($albumid);
		if (!$album) $this->showError('PHOTO:album.exist.fail');
		if ($album['created_uid'] != $this->loginUser->uid) $this->showError(
			'PHOTO:album.manage.fail');
		
		$photos = array();
		$page = intval($this->getInput('page'));
		$page < 1 && $page = 1;
		if ($album['photo_num']) {
			list($start, $num) = Pw::page2limit($page, $this->perpage);
			$photos = $this->_photoDs()->getPhotoListByAlbumid($albumid, $num, $start);
		}
		$this->setOutput(
			array(
				'album' => $album, 
				'page' => $page, 
				'perpage' => $this->perpage, 
				'photos' => $photos));
		// seo设置
		Wind::import('SRV:seo.bo.PwSeoBo');
		$lang = Wind::getComponent('i18n');
		PwSeoBo::setCustomSeo($lang->getMessage('PHOTO:album.photo.run.title', array($album['name'])), '', '');
	}

	/**
	 * 上传照片
	 */
	public function uploadAction() {
		$albumid = intval($this->getInput('albumid'));
		if (!$albumid) {
			$album = $this->_albumDs()->getAlbumsByUidAndType($this->loginUser->uid, 
				PwAlbumDm::ALBUM_TYPE_DEFAULT);
			$album = current($album);
		} else {
			$album = $this->_albumDs()->getAlbum($albumid);
		}
		$maxphoto = Wekit::config('ALBUM', 'maxphoto');
		
		$extsize = Wekit::config('ATTACHMENT', 'extsize');
		$albums = $this->_albumDs()->getAlbumsByUidAndType($this->loginUser->uid, 
			PwAlbumDm::ALBUM_TYPE_COMMON + PwAlbumDm::ALBUM_TYPE_DEFAULT);
		foreach ($albums as $k => $v) {
			if ($v['photo_num'] >= $maxphoto) unset($albums[$k]);
		}
		$hasVerifyCode = in_array('uploadpic', Wekit::config('verify', 'showverify'));
		$this->setOutput(
			array(
				'extsize' => $extsize, 
				'albums' => $albums, 
				'album' => $album, 
				'maxphoto' => $maxphoto,
				'hasVerifyCode' => $hasVerifyCode
				));
	}

	/**
	 * 跳转到上传成功后页面
	 */
	public function uploadSuccessAction() {
		list($ids, $albumid) = $this->getInput(array('photos', 'albumid'));
		$photoids = explode('|', $ids);
		$album = $this->_albumDs()->getAlbum($albumid);
		if (empty($photoids)) $this->showError('PHOTO:photo.upload.none');
		$photos = $this->_photoDs()->fetchPhoto($photoids);
		if (!$album) $this->showError('PHOTO:album.exist.fail');
		if (!$album['cover']) {
			$photo = end($photos);
			$this->_setCover($albumid, $this->_getCover($photo['path'], $photo['ifthumb']));
		}
		// send weibo?
		
		$this->setOutput($photos, 'photos');
		$this->setOutput($ids, 'ids');
		$this->setOutput($albumid, 'albumid');
	}

	/**
	 * 上传成功后批量修改标题和描述
	 */
	public function batchUpdateAction() {
		list($commonTitle, $commonDesc, $photos, $customs, $cover, $albumid) = $this->getInput(
			array('commonTitle', 'commonDesc', 'photos', 'customs', 'cover', 'albumid'));
		
		$album = $this->_albumDs()->getAlbum($albumid);
		if (!$album || $album['created_uid'] != $this->loginUser->uid) $this->showError(
			'PHOTO:album.manage.fail');
		// 设为封面
		if ($cover) $this->_setCover((int) $albumid, $cover);
		
		// 非统一标题描述，自定义
		$clear = array();
		if ($customs) {
			foreach ($customs as $v) {
				$clear[] = $v['id'];
				$dm = new PwPhotoDm();
				$dm->setPhotoid($v['id'])->setName($v['title'])->setDescrip($v['descrip']);
				$r = $this->_photoDs()->updatePhoto($dm);
				if ($r instanceof PwError) $this->showError($r->getError());
			}
		}
		$photos = array_diff($photos, $clear);
		
		// 设置剩余的统一标题描述
		if ($photos && ($commonTitle || $commonDesc)) {
			$dm = new PwPhotoDm();
			$commonTitle && $dm->setName($commonTitle);
			$commonDesc && $dm->setDescrip($commonDesc);
			$r = $this->_photoDs()->batchUpdatePhoto($photos, $dm);
			if ($r instanceof PwError) $this->showError($r->getError());
		}
		$this->showMessage('success');
	}

	/**
	 * 编辑照片
	 */
	public function editAction() {
		$photoid = $this->getInput('photoid');
		$photo = $this->_photoJoinDs()->getPhotoInfo($photoid);
		if (!$photo) $this->showError('PHOTO:photo.exist.fail');
		$this->setOutput($photo, 'photo');
	}

	/**
	 * 获取exif
	 */
	public function getExifAction() {
		$photoid = $this->getInput('photoid');
		$bo = new PwPhotoBo($photoid);
		if (!$bo->isPhoto()) $this->showError('PHOTO:photo.exist.fail');
		$this->setOutput($bo->getExif(), 'data');
		$this->showMessage('success');
	}

	/**
	 * 提交编辑
	 */
	public function doEditAction() {
		list($albumid, $photoid, $name, $descrip, $iscover, $path) = $this->getInput(
			array('albumid', 'photoid', 'name', 'descrip', 'iscover', 'path'), 'post');
		$bo = new PwPhotoBo($photoid);
		if (!$bo->isPhoto()) $this->showError('PHOTO:photo.exist.fail');
		if (!$bo->canEditPhoto($this->loginUser)) $this->showError('PHOTO:album.manage.fail');
		if ($iscover) $this->_setCover($albumid, $this->_getCover($path, $bo->info['ifthumb']));
		$photo = new PwPhotoDm();
		$photo->setPhotoid($photoid)->setName($name)->setDescrip($descrip);
		$r = $this->_photoDs()->updatePhoto($photo);
		if ($r instanceof PwError) $this->showError('PHOTO:photo.edit.fail');
		$this->showMessage('success');
	}

	/**
	 * 删除照片
	 */
	public function delAction() {
		$photoid = intval($this->getInput('photoid'));
		$bo = new PwPhotoBo($photoid);
		if (!$bo->isPhoto()) $this->showError('PHOTO:photo.exist.fail');
		if (!$bo->canEditPhoto($this->loginUser)) $this->showError('PHOTO:album.manage.fail');
		
		$r = $this->_service()->deletePhoto($bo);
		if ($r instanceof PwError) $this->showError($r->getError());
		
		$this->showMessage('success');
	}

	/**
	 * 照片页
	 */
	public function viewAction() {
		$photoid = $this->getInput('photoid');
		$bo = new PwPhotoBo($photoid);
		if (!$bo->isPhoto()) $this->showError('PHOTO:photo.exist.fail');
		if (!$bo->canEditPhoto($this->loginUser)) $this->showError('PHOTO:album.manage.fail');
		$photos = $bo->getPhotos();
		$this->setOutput(array('photo' => $bo->info, 'photos' => $photos));
		$this->setTemplate('photo_view');
		// seo设置
		Wind::import('SRV:seo.bo.PwSeoBo');
		$lang = Wind::getComponent('i18n');
		PwSeoBo::setCustomSeo($lang->getMessage('PHOTO:album.photo.view.title', array($bo->info['name'], $bo->info['albumname'])), '', '');
	}

	/**
	 * 添加评论
	 */
	public function addCommentAction() {
		list($photoid, $content) = $this->getInput(array('photoid', 'content'), 'post');
		$bo = new PwPhotoBo($photoid);
		if (!$bo->isPhoto()) $this->showError('PHOTO:photo.exist.fail');
		$r = $bo->addComment($this->loginUser->uid, $this->loginUser->username, $content);
		if ($r instanceof PwError) $this->showError($r->getError());
		$this->_loadComment($bo);
	}

	/**
	 * 删除评论
	 */
	public function delCommentAction() {
		list($commentid, $photoid) = $this->getInput(array('commentid', 'photoid'));
		$bo = new PwPhotoBo($photoid);
		if (!$bo->isPhoto()) $this->showError('PHOTO:photo.exist.fail');
		$comment = $this->_commentDs()->getComment($commentid);
		if (!$comment) $this->showError('PHOTO:comment.exist.fail');
		if ($bo->canEditPhoto($this->loginUser) || $comment['created_uid'] == $this->loginUser->uid) {
			$this->_service()->delPhotoComment($commentid, $photoid);
		} else {
			$this->showError('PHOTO:comment.del.auth');
		}
		$this->_loadComment($bo);
	}

	/**
	 * 获取评论
	 */
	public function getCommentAction() {
		$photoid = $this->getInput('photoid');
		$bo = new PwPhotoBo($photoid);
		if (!$bo->isPhoto()) $this->showError('PHOTO:photo.exist.fail');
		$this->_loadComment($bo);
	}

	/**
	 *
	 * @return PwPhotoComment
	 */
	private function _commentDs() {
		return Wekit::load('SRC:extensions.album.service.PwPhotoComment');
	}

	/**
	 *
	 * @return PwAlbum
	 */
	private function _albumDs() {
		return Wekit::load('SRC:extensions.album.service.PwAlbum');
	}

	/**
	 *
	 * @return PwPhoto
	 */
	private function _photoDs() {
		return Wekit::load('SRC:extensions.album.service.PwPhoto');
	}

	/**
	 *
	 * @return PwPhotoJoin
	 */
	private function _photoJoinDs() {
		return Wekit::load('SRC:extensions.album.service.PwPhotoJoin');
	}

	/**
	 *
	 * @return PwAlbumService
	 */
	private function _service() {
		return Wekit::load('SRC:extensions.album.service.srv.PwAlbumService');
	}

	private function _getCover($path, $ifthumb) {
		$dir = dirname($path);
		$file = basename($path);
		if ($ifthumb & 1) {
			$dir .= '/thumb';
		}
		return $dir . '/' . $file;
	}

	private function _setCover($albumid, $cover) {
		$dm = new PwAlbumDm();
		$dm->setAlbumid($albumid)->setCover($cover);
		$r = $this->_albumDs()->updateAlbum($dm);
		if ($r instanceof PwError) $this->showError($r->getError());
	}

	/**
	 *
	 * @param $bo PwPhotoBo        	
	 */
	private function _loadComment($bo) {
		$canEdit = $bo->canEditPhoto($this->loginUser);
		list($count, $comments, $page, $nextpage) = $bo->getComments($this->getInput('page'));
		$result = array();
		Wind::import('LIB:ubb.PwUbbCode');
		foreach ($comments as $k => $v) {
			$result[$k] = array(
				'created_uid' => $v['created_uid'], 
				'canEdit' => $canEdit || ($v['created_uid'] == $this->loginUser->uid), 
				'commentid' => $k, 
				'photoid' => $v['photoid'], 
				'content' => PwUbbCode::parseEmotion($v['content']), 
				'created_time' => Pw::time2str($v['created_time'], 'auto'), 
				'created_username' => $v['created_username']);
		}
		$this->setOutput(array(
			'count' => $count,
			'page' => $page,
			'nextpage' => $nextpage,
			'perpage' => $bo->comment_perpage,
			'comments' => $result,
			'photoid' => $bo->photoid
			));
		$this->setTemplate('photo_getComment');
	}
}

?>