<?php
Wind::import('APPS:space.controller.SpaceBaseController');
Wind::import('SRC:extensions.album.service.dm.PwAlbumDm');
Wind::import('SRC:extensions.album.service.dm.PwPhotoDm');
Wind::import('SRC:extensions.album.service.dm.PwPhotoCommentDm');
Wind::import('SRC:extensions.album.service.PwAlbum');
/**
 * 个人空间 相册
 *
 * @author Shi Long <long.shi@alibaba-inc.com>
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: SpaceController.php 16847 2012-08-29 03:25:06Z long.shi $
 * @package album.controller
 */
class SpaceController extends SpaceBaseController {
	private $privacy;
	private $perpage = 20;

	public function beforeAction($handlerAdapter) {
		parent::beforeAction($handlerAdapter);
		if (!Wekit::config('SITE', 'album.isopen')) $this->showError('PHOTO:closed');
		$this->privacy = PwAlbum::PRIVACY_PUBLIC;
		if ($this->space->tome == PwSpaceBo::ATTENTION)
			$this->privacy += PwAlbum::PRIVACY_FANS;
		elseif ($this->space->tome == PwSpaceBo::MYSELF)
			$this->privacy += PwAlbum::PRIVACY_PRIVATE;
		$this->setOutput('album', 'src');
	}
	
	/*
	 * (non-PHPdoc) @see WindController::run() 空间相册列表
	 */
	public function run() {
		$this->_service()->getDefaultAlbumidByType($this->space->spaceUid);
		if ($this->space->tome == PwSpaceBo::MYSELF)
			$albums = $this->_albumDs()->getMyAlbums($this->loginUser->uid);
		else
			$albums = $this->_albumDs()->getAlbumsByUidAndPrivacy($this->space->spaceUid, 
				$this->privacy);
		$this->setOutput($albums, 'albums');
		
		// seo设置
		Wind::import('SRV:seo.bo.PwSeoBo');
		$lang = Wind::getComponent('i18n');
		PwSeoBo::setCustomSeo(
			$lang->getMessage('PHOTO:album.space.run.title', 
				array($this->space->spaceUser['username'], $this->space->space['space_name'])), '', 
			$lang->getMessage('PHOTO:album.space.run.description', 
				array($this->space->spaceUser['username'])));
	}

	/**
	 * 空间照片列表
	 */
	public function photoAction() {
		$albumid = $this->getInput('albumid');
		$album = $this->_albumDs()->getAlbum($albumid);
		if (!$album) $this->showError('PHOTO:album.exist.fail');
		// 检测相册权限设置
		if (!$this->privacy & $album['privacy']) $this->showError('PHOTO:album.privacy');
		
		$photos = array();
		$page = intval($this->getInput('page'));
		$page < 1 && $page = 1;
		if ($album['photo_num']) {
			list($start, $num) = Pw::page2limit($page, $this->perpage);
			$photos = $this->_photoDs()->getPhotoListByAlbumid($albumid, $num, $start);
		}
		$this->setOutput(
			array(
				'album' => $album, 
				'page' => $page, 
				'perpage' => $this->perpage, 
				'photos' => $photos));
		
		// seo设置
		Wind::import('SRV:seo.bo.PwSeoBo');
		$lang = Wind::getComponent('i18n');
		$des = $lang->getMessage('PHOTO:album.space.photo.description', array(Pw::substrs($album['descrip'], 100, 0,false)));
		if ($page == 1) PwSeoBo::setCustomSeo($lang->getMessage('PHOTO:album.space.photo.title', array($album['name'], $this->space->space['space_name'])), '', $des);
		else PwSeoBo::setCustomSeo($lang->getMessage('PHOTO:album.space.photo.page.title', array($album['name'], $page, $this->space->space['space_name'])), '', $des);
	}

	/**
	 * 空间照片详细页
	 *
	 * @return PwError
	 */
	public function viewAction() {
		list($photoid, $page) = $this->getInput(array('photoid', 'page'));
		Wind::import('SRC:extensions.album.service.bo.PwPhotoBo');
		$bo = new PwPhotoBo($photoid);
		if (!$bo->isPhoto()) $this->showError('PHOTO:photo.exist.fail');
		
		// 检测相册权限设置
		if (!$this->privacy & $bo->info['privacy']) $this->showError('PHOTO:album.privacy');
		
		$photos = $bo->getPhotos();
		
		$this->setOutput(array('photo' => $bo->info, 'photos' => $photos));
		
		// seo设置
		Wind::import('SRV:seo.bo.PwSeoBo');
		$lang = Wind::getComponent('i18n');
		$des = $lang->getMessage('PHOTO:album.space.view.description', array(Pw::substrs($bo->info['descrip'], 100, 0, false)));
		PwSeoBo::setCustomSeo($lang->getMessage('PHOTO:album.space.view.title', array($bo->info['name'], $this->space->space['space_name'])), '', $des);
	}

	/**
	 *
	 * @return PwAlbum
	 */
	private function _albumDs() {
		return Wekit::load('SRC:extensions.album.service.PwAlbum');
	}

	/**
	 *
	 * @return PwPhoto
	 */
	private function _photoDs() {
		return Wekit::load('SRC:extensions.album.service.PwPhoto');
	}

	/**
	 *
	 * @return PwAlbumService
	 */
	private function _service() {
		return Wekit::load('SRC:extensions.album.service.srv.PwAlbumService');
	}
}

?>