<?php
/**
 * 供照片上传
 *
 * @author Shi Long <long.shi@alibaba-inc.com>
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: UploadController.php 17708 2012-09-08 03:11:54Z long.shi $
 * @package album.controller
 */
class UploadController extends PwBaseController {
	
	public function run() {
		if (!Wekit::config('SITE', 'album.isopen')) $this->showError('PHOTO:closed');
		$authkey = 'winduser';
		$pre = Wekit::config('site', 'cookie.pre');
		$pre && $authkey = $pre . '_' . $authkey;
		$winduser = $this->getInput($authkey, 'post');
		list($uid, $password) = explode("\t", Pw::decrypt(urldecode($winduser)));
		$user = new PwUserBo($uid);
		if (!$user->isExists() || Pw::getPwdCode($user->info['password']) != $password) {
			$this->showError('login.not');
		} else {
			unset($user->info['password']);
		}
		
		$albumid = $this->getInput('albumid', 'post');
		Wind::import('SRC:extensions.album.service.srv.upload.PwPhotoUpload');
		Wind::import('SRV:upload.PwUpload');
		$bhv = new PwPhotoUpload($user->uid, $albumid);
		$upload = new PwUpload($bhv);
		if (($result = $upload->check()) === true) {
			$result = $upload->execute();
		}
		if ($result !== true) {
			$this->showError($result->getError());
		}
		// 积分
		Wind::import('SRV:credit.bo.PwCreditBo');
		/* @var $creditBo PwCreditBo */
		$creditBo = PwCreditBo::getInstance();
		$creditBo->operate('album_upload', $user);
		
		$this->setOutput($bhv->getCurrentAttach(), 'data');
		$this->showMessage('upload.success');
	}
}

?>