<?php
/**
 * 相册 ds
 *
 * @author Shi Long <long.shi@alibaba-inc.com>
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwAlbum.php 10727 2012-05-29 09:30:47Z long.shi $
 * @package album
 */
class PwAlbum {
	
	const PRIVACY_PUBLIC = 1;
	const PRIVACY_FANS = 2;
	const PRIVACY_PRIVATE = 4;
	
	/**
	 * 添加相册
	 *
	 * @param PwAlbumDm $dm
	 * @return boolean
	 */
	public function addAlbum(PwAlbumDm $dm) {
		if (($r = $dm->beforeAdd()) instanceof PwError) return $r;
		return $this->_albumDao()->addAlbum($dm->getData());
	}
	
	/**
	 * 批量添加相册
	 *
	 * @param array $fields
	 * @return boolean
	 */
	public function batchAddAlbum($dms) {
		if (!is_array($dms) || empty($dms)) return new PwError('PHOTO:add.fail');
		$data = array();
		foreach ($dms as $dm) {
			if (!$dm instanceof PwAlbumDm) return new PwError('PHOTO:add.fail');
			if (($r = $dm->beforeAdd()) instanceof PwError) return $r;
			$data[] = $dm->getData();
		}
		return $this->_albumDao()->batchAddAlbum($data);
	}
	
	/**
	 * 修改
	 *
	 * @param PwAlbumDm $dm
	 * @return boolean
	 */
	public function updateAlbum(PwAlbumDm $dm) {
		if (($r = $dm->beforeUpdate()) instanceof PwError) return $r;
		return $this->_albumDao()->updateAlbum($dm->albumid, $dm->getData(), $dm->getIncreaseData());
	}
	
	/**
	 * 删除
	 *
	 * @param int $albumid
	 * @return boolean
	 */
	public function deleteAlbum($albumid) {
		return $this->_albumDao()->deleteAlbum((int)$albumid);
	}
	
	/**
	 * 获取所有相册
	 *
	 * @param int $created_uid
	 * @param int $num
	 * @param int $start
	 * @return array
	 */
	public function getMyAlbums($created_uid) {
		if (0 >= ($created_uid = intval($created_uid))) return array();
		return $this->_albumDao()->getMyAlbums($created_uid);
	}
	
	/**
	 * 根据是否默认相册查询
	 *
	 * @param int $created_uid
	 * @param int $albumType
	 * @return array
	 */
	public function getAlbumsByUidAndType($created_uid, $albumType = 0) {
		if (0 >= ($created_uid = intval($created_uid))) return array();
		return $this->_albumDao()->getAlbumsByUidAndType($created_uid, (int)$albumType);
	}
	
	/**
	 * 根据相册类型查询总数
	 *
	 * @param int $created_uid
	 * @param int $albumType
	 * @return int
	 */
	public function countByUidAndType($created_uid, $albumType = 0) {
		if (0 >= ($created_uid = intval($created_uid))) return 0;
		return $this->_albumDao()->countByUidAndType($created_uid, (int)$albumType);
	}
	
	/**
	 * 根据权限获取相册
	 *
	 * @param int $created_uid
	 * @param int $privacy
	 * @return array
	 */
	public function getAlbumsByUidAndPrivacy($created_uid, $privacy) {
		if (0 >= ($created_uid = intval($created_uid))) return array();
		return $this->_albumDao()->getAlbumsByUidAndPrivacy($created_uid, (int)$privacy);
	}
	
	/**
	 * 获取相册详细信息
	 *
	 * @param int $albumid
	 * @return array
	 */
	public function getAlbum($albumid) {
		if (0 >= ($albumid = intval($albumid))) return array();
		return $this->_albumDao()->getAlbum($albumid);
	}
	
	/**
	 * @return PwAlbumDao
	 */
	private function _albumDao() {
		return Wekit::loadDao('SRC:extensions.album.service.dao.PwAlbumDao');
	}
}

?>