<?php
/**
 * 照片 ds
 *
 * @author Shi Long <long.shi@alibaba-inc.com>
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwPhoto.php 11677 2012-06-12 02:50:15Z long.shi $
 * @package album
 */
class PwPhoto {
	/**
	 * 添加照片
	 *
	 * @param PwPhotoDm $dm
	 * @return boolean
	 */
	public function addPhoto(PwPhotoDm $dm) {
		if (($r = $dm->beforeAdd()) instanceof PwError) return $r;
		return $this->_photoDao()->addPhoto($dm->getData());
	}
	
	/**
	 * 批量添加照片
	 *
	 * @param array $dms
	 * @return PwError|boolean
	 */
	public function batchAddPhoto($dms) {
		if (!is_array($dms) || empty($dms)) return new PwError('PHOTO:add.fail');
		$data = array();
		foreach ($dms as $dm) {
			if (!$dm instanceof PwPhotoDm) return new PwError('PHOTO:add.fail');
			if (($r = $dm->beforeAdd()) instanceof PwError) return $r;
			$data[] = $dm->getData();
		}
		return $this->_photoDao()->batchAddPhoto($data);
	}
	
	/**
	 * 编辑照片
	 *
	 * @param int $id
	 * @param PwPhotoDm $dm
	 * @return boolean
	 */
	public function updatePhoto(PwPhotoDm $dm) {
		if (($r = $dm->beforeUpdate()) instanceof PwError) return $r;
		return $this->_photoDao()->updatePhoto($dm->photoid, $dm->getData(), $dm->getIncreaseData());
	}
	
	/**
	 * 批量更新照片，比如统一设置标题描述
	 *
	 * @param array $ids
	 * @param array $fields
	 * @return boolean
	 */
	public function batchUpdatePhoto($ids, PwPhotoDm $dm) {
		if (!$ids || !is_array($ids)) return new PwError('PHOTO:update.fail');
		return $this->_photoDao()->batchUpdatePhoto($ids, $dm->getData());
	}
	
	/**
	 * 删除照片
	 *
	 * @param int $photoid
	 * @return boolean
	 */
	public function deletePhoto($photoid) {
		if (0 >= ($photoid = intval($photoid))) return false;
		return $this->_photoDao()->deletePhoto($photoid);
	}
	
	/**
	 * 批量删除照片
	 *
	 * @param array $ids
	 * @return boolean
	 */
	public function batchDeletePhoto($ids) {
		if (empty($ids) || !is_array($ids)) return false;
		return $this->_photoDao()->batchDeletePhoto($ids);
	}
	
	/**
	 * 根据相册id删除照片
	 *
	 * @param int $albumid
	 * @return boolean
	 */
	public function deleteByAlbumid($albumid) {
		if (0 >= ($albumid = intval($albumid))) return false;
		return $this->_photoDao()->deleteByAlbumid($albumid);
	}
	
	/**
	 * 获取后一张照片
	 *
	 * @param int $photoid
	 * @param int $albumid
	 * @return Array
	 */
	public function getNextPhoto($photoid, $albumid) {
		$photoid = intval($photoid);
		$albumid = intval($albumid);
		if ($photoid < 0 || $albumid < 0) return array();
		return $this->_photoDao()->getNextPhoto($photoid, $albumid);
	}
	
	/**
	 * 获取前一张照片
	 *
	 * @param int $photoid
	 * @param int $albumid
	 * @return array
	 */
	public function getPrePhoto($photoid, $albumid) {
		$photoid = intval($photoid);
		$albumid = intval($albumid);
		if ($photoid < 0 || $albumid < 0) return array();
		return $this->_photoDao()->getPrePhoto($photoid, $albumid);
	}
	
	/**
	 * 获取一张照片
	 *
	 * @param int $photoid
	 * @return array 
	 */
	public function getPhoto($photoid) {
		$photoid = intval($photoid);
		if ($photoid < 0) return array();
		return $this->_photoDao()->getPhoto($photoid);
	}
	
	/**
	 * 批量获取照片
	 *
	 * @param array $ids
	 * @return array
	 */
	public function fetchPhoto($ids) {
		if (!$ids) return array();
		return $this->_photoDao()->fetchPhoto((array)$ids);
	}
	
	/**
	 * 获取相册的照片列表
	 *
	 * @param int $albumid
	 * @param int $num
	 * @param int $start
	 * @return array
	 */
	public function getPhotoListByAlbumid($albumid, $num = 10, $start = 0) {
		return $this->_photoDao()->getPhotoListByAlbumid((int)$albumid, (int)$num, (int)$start);
	}
	
	/**
	 * @return PwPhotoDao
	 */
	private function _photoDao() {
		return Wekit::loadDao('SRC:extensions.album.service.dao.PwPhotoDao');
	}
}

?>