<?php
/**
 * 相册评论 ds
 *
 * @author Shi Long <long.shi@alibaba-inc.com>
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwPhotoComment.php 15616 2012-08-09 07:25:59Z long.shi $
 * @package album
 */
class PwPhotoComment {
	
	/**
	 * 获取一条评论详细信息
	 *
	 * @param int $commentid
	 * @return array
	 */
	public function getComment($commentid) {
		if (0 >= ($commentid = intval($commentid))) return array();
		return $this->_commentDao()->getComment($commentid);
	}
	
	/**
	 * 删除一条评论
	 *
	 * @param int $commentid
	 * @return array
	 */
	public function delComment($commentid) {
		return $this->_commentDao()->delComment($commentid);
	}
	
	/**
	 * 添加评论
	 *
	 * @param array $fields
	 * @return int
	 */
	public function addComment(PwPhotoCommentDm $dm) {
		if (($r = $dm->beforeAdd()) instanceof PwError) return $r;
		return $this->_commentDao()->addComment($dm->getData());
	}
	
	/**
	 * 根据照片获取评论
	 *
	 * @param int $photoid
	 * @return array
	 */
	public function getCommentListByPhotoid($photoid, $num = 10, $start = 0) {
		if (0 >= ($photoid = intval($photoid))) return array();
		return $this->_commentDao()->getCommentListByPhotoid($photoid, (int)$num, (int)$start);
	}
	
	/**
	 * 获取照片评论数
	 *
	 * @param int $photoid
	 * @return int
	 */
	public function countByPhotoid($photoid) {
		if (0 >= ($photoid = intval($photoid))) return 0;
		return $this->_commentDao()->countByPhotoid($photoid);
	}
	
	/**
	 * @return PwPhotoCommentDao
	 */
	private function _commentDao() {
		return Wekit::loadDao('SRC:extensions.album.service.dao.PwPhotoCommentDao');
	}
}

?>