<?php
/**
 * 后台搜索照片
 *
 * @author Shi Long <long.shi@alibaba-inc.com>
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwPhotoJoin.php 12012 2012-06-15 08:02:33Z long.shi $
 * @package album
 */
class PwPhotoJoin {
	
	/**
	 * 获取照片详细信息
	 *
	 * @param int $photoid
	 * @return array
	 */
	public function getPhotoInfo($photoid) {
		if (0 >= ($photoid = intval($photoid))) return array();
		return $this->_searchDao()->getPhotoInfo($photoid);
	}
	
	/**
	 * 搜索结果数
	 *
	 * @param PwPhotoSo $so
	 * @return int
	 */
	public function countSearchPhoto(PwPhotoSo $so) {
		return $this->_searchDao()->countSearchPhoto($so->getData());
	}
	
	/**
	 * 搜索照片
	 *
	 * @param PwPhotoSo $so
	 * @param int $num
	 * @param int $start
	 * @return array
	 */
	public function searchPhoto(PwPhotoSo $so, $num = 10, $start = 0) {
		return $this->_searchDao()->searchPhoto($so->getData(), (int)$num, (int)$start);		
	}
	
	/**
	 * @return PwPhotoJoinDao
	 */
	private function _searchDao() {
		return Wekit::loadDao('SRC:extensions.album.service.dao.PwPhotoJoinDao');
	}
}

?>