<?php
/**
 * 相册业务模型
 *
 * @author Shi Long <long.shi@alibaba-inc.com>
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwPhotoBo.php 15704 2012-08-10 09:08:37Z long.shi $
 * @package album.service.bo
 */
class PwPhotoBo {
	public $photoid;
	public $info;
	public $comment_perpage = 20;
	const MAX_PHOTO_NUM = 200;

	public function __construct($photoid) {
		$this->photoid = intval($photoid);
		$this->info = Wekit::load('SRC:extensions.album.service.PwPhotoJoin')->getPhotoInfo(
			(int) $photoid);
	}

	/**
	 *
	 * @param $userbo PwUserBo        	
	 */
	public function canEditPhoto($userbo) {
		return 3 == $userbo->info['groupid'] || $this->info['created_uid'] == $userbo->uid;
	}

	/**
	 * 照片是否存在
	 *
	 * @return boolean
	 */
	public function isPhoto() {
		if (!$this->info) return false;
		return true;
	}

	/**
	 * 获取这个相册的所有照片
	 *
	 * @return array
	 */
	public function getPhotos() {
		return $this->_photoDs()->getPhotoListByAlbumid($this->info['albumid'], self::MAX_PHOTO_NUM);
	}

	/**
	 * 获取这张照片的邻近照片
	 *
	 * @return array
	 * @deprecated
	 *
	 */
	public function getNearPhotos() {
		$photos = $this->_photoDs()->getPhotoListByAlbumid($this->info['albumid'], 0, 200);
		if (empty($photos)) return array(array(), null, null);
		$photoids = array_keys($photos);
		$current = array_search($this->photoid, $photoids);
		$total = count($photos);
		
		$preid = $current === 0 ? null : $photoids[$current - 1];
		$nextid = $current === $total - 1 ? null : $photoids[$current + 1];
		
		$nearPhotos = array();
		if ($total > $this->near_photos_perpage) {
			$center = ceil($this->near_photos_perpage - 1) / 2;
			if ($current <= $center)
				$start = 0;
			elseif ($current + $center >= $total)
				$start = $total - $this->near_photos_perpage;
			else
				$start = $current - $center;
			$nearPhotos = array_slice($photos, $start, $this->near_photos_perpage);
		} else
			$nearPhotos = $photos;
		return array($nearPhotos, $preid, $nextid, $photos);
	}

	/**
	 * 获取exif信息
	 *
	 * @return array
	 */
	public function getExif() {
		$exif = array();
		$img = Pw::getPath($this->info['path']);
		if (function_exists('exif_read_data')) {
			$r = @exif_read_data($img, 'IFD0');
			$r && $exif = exif_read_data($img, 0, true);
		}
		if (empty($exif))
			return array();
		else
			return array(
				$this->_select($exif['IFD0']['Make']),  // 厂商
				$this->_select($exif['IFD0']['Model']),  // 型号
				$this->_select($exif['EXIF']['DateTimeOriginal']),  // 日期
				($exif['COMPUTED']['Width'] && $exif['COMPUTED']['Height']) ? $exif['COMPUTED']['Width'] . '*' . $exif['COMPUTED']['Height'] : '',  // 大小
				$this->_select($exif['EXIF']['FocalLength']),  // 焦距
				$this->_select($exif['EXIF']['FNumber']),  // 光圈
				$this->_select($exif['EXIF']['ExposureTime']),  // 曝光时间
				$this->_select($exif['EXIF']['ISOSpeedRatings']),  // 感光度
				$this->_select($exif['EXIF']['ExposureProgram']),  // 曝光程序
				$this->_select($exif['EXIF']['MeteringMode']))			// 测光模式
			;
	}

	/**
	 * 获取照片的评论
	 *
	 * @param int $page        	
	 */
	public function getComments($page) {
		$page = intval($page);
		$page < 1 && $page = 1;
		/* @var $commentDs PwPhotoComment */
		$commentDs = Wekit::load('SRC:extensions.album.service.PwPhotoComment');
		$count = $commentDs->countByPhotoid($this->photoid);
		if ($count === 0) return array(0, 1, array());
		$total = ceil($count / $this->comment_perpage);
		$page > $total && $page = $total;
		$nextpage = $page < $total;
		list($start, $num) = Pw::page2limit($page, $this->comment_perpage);
		$comments = $commentDs->getCommentListByPhotoid($this->photoid, $num, $start);
		return array($count, $comments, $page, $nextpage);
	}

	/**
	 * 发表评论
	 *
	 * @param string $content        	
	 * @return Ambigous <PwError, Ambigous, boolean, multitype:, number,
	 *         rowCount>
	 */
	public function addComment($uid, $username, $content) {
		Wind::import('SRC:extensions.album.service.dm.PwPhotoCommentDm');
		$dm = new PwPhotoCommentDm();
		$dm->setCreatedUid($uid)->setContent($content)->setPhotoid($this->photoid)->setCreatedUsername(
			$username);
		return $this->_service()->addPhotoComment($dm);
	}

	/**
	 *
	 * @return PwPhoto
	 */
	private function _photoDs() {
		return Wekit::load('SRC:extensions.album.service.PwPhoto');
	}

	/**
	 *
	 * @return PwAlbumService
	 */
	private function _service() {
		return Wekit::load('SRC:extensions.album.service.srv.PwAlbumService');
	}

	private function _select($value) {
		return $value ? $value : '';
	}
}

?>