<?php
/**
 * 相册
 *
 * @author Shi Long <long.shi@alibaba-inc.com>
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwAlbumDao.php 10727 2012-05-29 09:30:47Z long.shi $
 * @package album.service.dao
 */
class PwAlbumDao extends PwBaseDao {
	protected $_table = 'album';
	protected $_pk = 'albumid';
	protected $_dataStruct = array(
		'albumid',
		'created_uid',
		'privacy',
		'album_type',
		'photo_num',
		'created_time',
		'modified_time',
		'name',
		'cover',
		'descrip',
	);
	
	/**
	 * 添加相册
	 *
	 * @param array $data
	 * @return boolean
	 */
	public function addAlbum($data) {
		return $this->_add($data, true);
	}
	
	/**
	 * 批量添加相册
	 *
	 * @param array $fields
	 * @return boolean
	 */
	public function batchAddAlbum($fields) {
		if (!is_array($fields)) return false;
		$data = array();
		foreach ($fields as $v) {
			$v = $this->_filterStruct($v);
			$v && $data[] = array($v['created_uid'], $v['privacy'], $v['album_type'], $v['photo_num'], $v['created_time'], $v['modified_time'], $v['name'], $v['cover'], $v['descrip']);
		}
		if (empty($data)) return false;
		$sql = $this->_bindSql('INSERT INTO %s (created_uid, privacy, album_type, photo_num, created_time,	modified_time, name, cover, descrip) VALUES %s', $this->getTable(), $this->sqlMulti($data)); 
		return $this->getConnection()->execute($sql);
	}
	
	/**
	 * 编辑
	 *
	 * @param int $albumid
	 * @param array $data
	 * @return boolean
	 */
	public function updateAlbum($albumid, $data, $increaseFields = array()) {
		return $this->_update($albumid, $data, $increaseFields);
	}
	
	/**
	 * 删除相册
	 *
	 * @param int $albumid
	 * @return boolean
	 */
	public function deleteAlbum($albumid) {
		return $this->_delete($albumid);
	}
	
	/**
	 * 获取我的所有相册
	 *
	 * @param int $created_uid
	 * @return array
	 */
	public function getMyAlbums($created_uid) {
		$sql = $this->_bindTable('SELECT * FROM %s WHERE created_uid = ? ORDER BY created_time DESC');
		return $this->getConnection()->createStatement($sql)->queryAll(array($created_uid), $this->_pk);
	}
	
	/**
	 * 根据权限获取相册
	 *
	 * @param int $created_uid
	 * @param int $privacy
	 * @return array
	 */
	public function getAlbumsByUidAndPrivacy($created_uid, $privacy) {
		$sql = $this->_bindTable('SELECT * FROM %s WHERE created_uid = ? AND privacy & ? ORDER BY created_time DESC');
		return $this->getConnection()->createStatement($sql)->queryAll(array($created_uid, $privacy), $this->_pk);
	}
	
	/**
	 * 根据相册类型查询
	 *
	 * @param int $created_uid
	 * @param int $albumType
	 * @return array
	 */
	public function getAlbumsByUidAndType($created_uid, $albumType = 0) {
		$sql = $this->_bindTable('SELECT * FROM %s WHERE created_uid = ? AND album_type & ? ORDER BY created_time DESC');
		return $this->getConnection()->createStatement($sql)->queryAll(array($created_uid, $albumType), $this->_pk);
	}
	
	/**
	 * 获取相册详细信息
	 *
	 * @param int $albumid
	 * @return array
	 */
	public function getAlbum($albumid) {
		return $this->_get($albumid);
	}
	
	/**
	 * 根据相册类型查询总数
	 *
	 * @param int $created_uid
	 * @param int $albumType
	 * @return int
	 */
	public function countByUidAndType($created_uid, $albumType = 0) {
		$sql = $this->_bindTable('SELECT COUNT(*) FROM %s WHERE created_uid = ? AND album_type & ?');
		return $this->getConnection()->createStatement($sql)->getValue(array($created_uid, $albumType));
	}
}

?>