<?php
/**
 * 相册评论
 *
 * @author Shi Long <long.shi@alibaba-inc.com>
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwPhotoCommentDao.php 15616 2012-08-09 07:25:59Z long.shi $
 * @package photo.dao
 */
class PwPhotoCommentDao extends PwBaseDao {
	protected $_table = 'album_photo_comment';
	protected $_pk = 'commentid';
	protected $_dataStruct = array(
		'commentid', 
		'photoid', 
		'created_uid', 
		'created_time', 
		'created_username', 
		'content');

	/**
	 * 获取一条评论详细信息
	 *
	 * @param int $commentid        	
	 * @return array
	 */
	public function getComment($commentid) {
		return $this->_get($commentid);
	}

	/**
	 * 删除一条评论
	 *
	 * @param int $commentid        	
	 * @return array
	 */
	public function delComment($commentid) {
		return $this->_delete($commentid);
	}

	/**
	 * 添加评论
	 *
	 * @param array $fields        	
	 * @return int
	 */
	public function addComment($fields) {
		return $this->_add($fields);
	}

	/**
	 * 根据照片获取评论
	 *
	 * @param int $photoid        	
	 * @return array
	 */
	public function getCommentListByPhotoid($photoid, $num = 10, $start = 0) {
		$sql = $this->_bindSql('SELECT * FROM %s WHERE photoid = ? ORDER BY created_time DESC %s', 
			$this->getTable(), $this->sqlLimit($num, $start));
		return $this->getConnection()->createStatement($sql)->queryAll(array($photoid), $this->_pk);
	}

	/**
	 * 获取照片评论数
	 *
	 * @param int $photoid        	
	 * @return int
	 */
	public function countByPhotoid($photoid) {
		$sql = $this->_bindTable('SELECT COUNT(*) FROM %s WHERE photoid = ?');
		return $this->getConnection()->createStatement($sql)->getValue(array($photoid));
	}
}

?>