<?php
/**
 * 照片
 *
 * @author Shi Long <long.shi@alibaba-inc.com>
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwPhotoDao.php 11677 2012-06-12 02:50:15Z long.shi $
 * @package photo.dao
 */
class PwPhotoDao extends PwBaseDao {
	protected $_table = 'album_photo';
	protected $_pk = 'photoid';
	protected $_dataStruct = array(
		'photoid',
		'albumid',
		'ifthumb',
		'comment_num',
		'created_time',
		'name',
		'path',
		'descrip'
	);
	
	/**
	 * 添加一张照片
	 *
	 * @param array $fields
	 * @return int
	 */
	public function addPhoto($fields) {
		return $this->_add($fields, true);
	}
	
	/**
	 * 批量插入照片
	 *
	 * @param array $fields
	 * @return array|boolean
	 */
	public function batchAddPhoto($fields) {
		if (!is_array($fields)) return false;
		$data = array();
		foreach ($fields as $v) {
			$v = $this->_filterStruct($v);
			$v && $data[] = array($v['albumid'], $v['comment_num'], $v['created_time'], $v['name'], $v['path'], $v['descrip']);
		}
		if (empty($data)) return false;
		$sql = $this->_bindSql('INSERT INTO %s (albumid, comment_num, created_time,	name, path,	descrip) VALUES %s', $this->getTable(), $this->sqlMulti($data)); 
		return $this->getConnection()->execute($sql);
	}
	
	/**
	 * 编辑照片
	 *
	 * @param int $id
	 * @param array $fields
	 * @return boolean
	 */
	public function updatePhoto($id, $fields, $increaseFields = array()) {
		return $this->_update($id, $fields, $increaseFields);
	}
	
	/**
	 * 批量更新照片，比如统一设置标题描述
	 *
	 * @param array $ids
	 * @param array $fields
	 * @return boolean
	 */
	public function batchUpdatePhoto($ids, $fields) {
		return $this->_batchUpdate($ids, $fields);
	}
	
	/**
	 * 删除照片
	 *
	 * @param int $photoid
	 * @return boolean
	 */
	public function deletePhoto($photoid) {
		return $this->_delete($photoid);
	}
	
	/**
	 * 批量删除照片
	 *
	 * @param array $ids
	 * @return boolean
	 */
	public function batchDeletePhoto($ids) {
		return $this->_batchDelete($ids);
	}
	
	/**
	 * 根据相册id删除照片
	 *
	 * @param int $albumid
	 * @return boolean
	 */
	public function deleteByAlbumid($albumid) {
		$sql = $this->_bindTable('DELETE FROM %s WHERE albumid = ?');
		return $this->getConnection()->createStatement($sql)->update(array($albumid));
	}
	
	/**
	 * 获取后一张照片
	 *
	 * @param int $photoid
	 * @param int $albumid
	 * @return Array
	 */
	public function getNextPhoto($photoid, $albumid) {
		$sql = $this->_bindTable('SELECT * FROM %s WHERE albumid = ? AND photoid > ? ORDER BY photoid LIMIT 1');
		return $this->getConnection()->createStatement($sql)->getOne(array($albumid, $photoid));
	}
	
	/**
	 * 获取前一张照片
	 *
	 * @param int $photoid
	 * @param int $albumid
	 * @return array
	 */
	public function getPrePhoto($photoid, $albumid) {
		$sql = $this->_bindTable('SELECT * FROM %s WHERE albumid = ? AND photoid < ? ORDER BY photoid DESC LIMIT 1');
		return $this->getConnection()->createStatement($sql)->getOne(array($albumid, $photoid));
	}
	
	/**
	 * 获取一张照片
	 *
	 * @param int $photoid
	 * @return array 
	 */
	public function getPhoto($photoid) {
		return $this->_get($photoid);
	}
	
	/**
	 * 批量获取照片
	 *
	 * @param array $ids
	 * @return array
	 */
	public function fetchPhoto($ids) {
		return $this->_fetch($ids, $this->_pk);
	}
	
	/**
	 * 获取相册的照片列表
	 *
	 * @param int $albumid
	 * @param int $num
	 * @param int $start
	 * @return array
	 */
	public function getPhotoListByAlbumid($albumid, $num = 10, $start = 0) {
		$sql = $this->_bindSql('SELECT * FROM %s WHERE albumid = ? ORDER BY created_time DESC %s', $this->getTable(), $this->sqlLimit($num, $start));
		return $this->getConnection()->createStatement($sql)->queryAll(array($albumid), $this->_pk);
	}
	
}

?>