<?php
/**
 * 照片搜索（后台）
 *
 * @author Shi Long <long.shi@alibaba-inc.com>
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwPhotoJoinDao.php 12012 2012-06-15 08:02:33Z long.shi $
 * @package album.dao
 */
class PwPhotoJoinDao extends PwBaseDao {
	
	protected $_table = 'album_photo';
	protected $_joinTable = 'album';
	protected $_pk = 'photoid';

	/**
	 * 获取照片详细信息
	 *
	 * @param int $photoid
	 * @return array
	 */
	public function getPhotoInfo($photoid) {
		$sql = $this->_bindSql(
			'SELECT a.*, b.name as albumname, b.photo_num, b.album_type, b.privacy, b.created_uid, b.cover FROM %s a LEFT JOIN %s b ON a.albumid = b.albumid WHERE a.photoid = ?', 
			$this->getTable(), $this->getTable($this->_joinTable));
		return $this->getConnection()->createStatement($sql)->getOne(array($photoid));
	}
	
	/**
	 * 搜索结果数
	 *
	 * @param array $fields
	 * @return int
	 */
	public function countSearchPhoto($fields) {
		list($where, $values, $joinTable) = $this->_bulidCondition($fields);
		if (empty($where)) return 0;
		$join = $joinTable ? $this->_bindTable(' LEFT JOIN %s b ON a.albumid = b.albumid', 
			$this->getTable($this->_joinTable)) : '';
		$sql = $this->_bindSql('SELECT COUNT(*) FROM %s a %s WHERE %s', $this->getTable(), $join, 
			$where);
		return $this->getConnection()->createStatement($sql)->getValue($values);
	}

	/**
	 * 搜索照片
	 *
	 * @param array $fields
	 * @param int $num
	 * @param int $start
	 * @return array
	 */
	public function searchPhoto($fields, $num = 10, $start = 0) {
		list($where, $values, $joinTable) = $this->_bulidCondition($fields);
		if (empty($where)) return array();
		$join = $joinTable ? $this->_bindTable(' LEFT JOIN %s b ON a.albumid = b.albumid', 
			$this->getTable($this->_joinTable)) : '';
		$sql = $this->_bindSql('SELECT a.* FROM %s a %s WHERE %s ORDER BY photoid DESC %s', 
			$this->getTable(), $join, $where, $this->sqlLimit($num, $start));
		return $this->getConnection()->createStatement($sql)->queryAll($values, $this->_pk);
	}

	private function _bulidCondition($fields) {
		$joinTable = false;
		$conditions = array();
		$values = array();
		foreach ($fields as $k => $v) {
			switch ($k) {
				case 'album':
					$conditions[] = 'b.name like ?';
					$values[] = "%$v%";
					$joinTable = true;
					break;
				case 'created_uid':
					$conditions[] = 'b.created_uid = ?';
					$values[] = $v;
					$joinTable = true;
					break;
				case 'name':
					$conditions[] = 'a.name like ?';
					$values[] = "%$v%";
					break;
				case 'descrip':
					$conditions[] = 'a.descrip like ?';
					$values[] = "%$v%";
					break;
				case 'min':
					$conditions[] = 'a.created_time > ?';
					$values[] = $v;
					break;
				case 'max':
					$conditions[] = 'a.created_time < ?';
					$values[] = $v;
					break;
			}
		}
		return array(implode(' AND ', $conditions), $values, $joinTable);
	}
}

?>