<?php
/**
 * 相册模型
 *
 * @author Shi Long <long.shi@alibaba-inc.com>
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwAlbumDm.php 15668 2012-08-10 02:50:32Z long.shi $
 * @package photo.dm
 */
class PwAlbumDm extends PwBaseDm {
	//普通类型的相册，受附件设置控制
	const ALBUM_TYPE_COMMON = 1;
	//默认相册
	const ALBUM_TYPE_DEFAULT = 2;
	//头像相册
	const ALBUM_TYPE_ICON = 4;
	
	public $albumid;
	
	/**
	 * 相册id
	 *
	 * @param int $v
	 * @return PwAlbumDm
	 */
	public function setAlbumid($v) {
		$this->albumid = $v;
		return $this;
	}
	
	/**
	 * 创建人
	 *
	 * @param int $v
	 * @return PwAlbumDm
	 */
	public function setCreatedUid($v) {
		$this->_data['created_uid'] = $v;
		return $this;
	}
	
	/**
	 * 权限
	 *
	 * @param int $v
	 * @return PwAlbumDm
	 */
	public function setPrivacy($v) {
		$this->_data['privacy'] = $v;
		return $this;
	}
	
	/**
	 * 设置相册类型
	 *
	 * @param int $v
	 * @return PwAlbumDm
	 */
	public function setAlbumType($v) {
		$this->_data['album_type'] = $v;
		return $this;
	}
	
	/**
	 * 设置照片数
	 *
	 * @param int $v
	 * @return PwAlbumDm
	 */
	public function setPhotoNum($v) {
		$this->_data['photo_num'] = $v;
		return $this;
	}
	
	/**
	 * 设置照片数
	 *
	 * @param int $v
	 * @return PwAlbumDm
	 */
	public function setIncreasePhotoNum($v) {
		$this->_increaseData['photo_num'] = $v;
		return $this;
	}
	
	/**
	 * 设置创建时间
	 *
	 * @param int $v
	 * @return PwAlbumDm
	 */
	public function setCreatedTime($v) {
		$this->_data['created_time'] = $v;
		return $this;
	}
	
	/**
	 * 设置修改时间
	 *
	 * @param int $v
	 * @return PwAlbumDm
	 */
	public function setModifiedTime($v) {
		$this->_data['modified_time'] = $v;
		return $this;
	}
	
	/**
	 * 设置名称
	 *
	 * @param string $v
	 * @return PwAlbumDm
	 */
	public function setName($v) {
		$this->_data['name'] = trim($v);
		return $this;
	}
	
	/**
	 * 设置封面
	 *
	 * @param string $v
	 * @return PwAlbumDm
	 */
	public function setCover($v) {
		$this->_data['cover'] = $v;
		return $this;
	}
	
	/**
	 * 设置描述
	 *
	 * @param string $v
	 * @return PwAlbumDm
	 */
	public function setDescrip($v) {
		$this->_data['descrip'] = trim($v);
		return $this;
	}
	
	/* (non-PHPdoc)
	 * @see PwBaseDm::_beforeAdd()
	 */
	protected function _beforeAdd() {
		if (isset($this->_data['name'])) {
			if (Pw::strlen($this->_data['name']) > 10) return new PwError('PHOTO:album.name.long');
			if ($this->_filter()->filter($this->_data['name'])) return new PwError('PHOTO:name.filter.fail');
		}
		if (isset($this->_data['descrip'])) {
			if (Pw::strlen($this->_data['descrip']) > 100) return new PwError('PHOTO:album.descrip.long');
			if (isset($this->_data['name']) && $this->_filter()->filter($this->_data['descrip'])) return new PwError('PHOTO:descrip.filter.fail');
		}
		$this->_data['created_time'] = $this->_data['modified_time'] = Pw::getTime();
	}

	/* (non-PHPdoc)
	 * @see PwBaseDm::_beforeUpdate()
	 */
	protected function _beforeUpdate() {
		if (!$this->albumid) return new PwError('PHOTO:id.empty');
		if (isset($this->_data['name'])) {
			if (Pw::strlen($this->_data['name']) > 10) return new PwError('PHOTO:album.name.long');
			if ($this->_filter()->filter($this->_data['name'])) return new PwError('PHOTO:name.filter.fail');
		}
		if (isset($this->_data['descrip'])) {
			if (Pw::strlen($this->_data['descrip']) > 100) return new PwError('PHOTO:album.descrip.long');
			if (isset($this->_data['name']) && $this->_filter()->filter($this->_data['descrip'])) return new PwError('PHOTO:descrip.filter.fail');
		}
		$this->_data['modified_time'] = Pw::getTime();
	}
	
	/**
	 * @return PwWordFilter
	 */
	private function _filter() {
		Wind::import('SRV:word.srv.PwWordFilter');
		return PwWordFilter::getInstance();
	}

}

?>