<?php
/**
 * 相册评论
 *
 * @author Shi Long <long.shi@alibaba-inc.com>
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwPhotoCommentDm.php 15668 2012-08-10 02:50:32Z long.shi $
 * @package album.dm
 */
class PwPhotoCommentDm extends PwBaseDm {
	
	/**
	 * 设置照片id
	 *
	 * @param int $v
	 * @return PwPhotoCommentDm
	 */
	public function setPhotoid($v) {
		$this->_data['photoid'] = $v;
		return $this;
	}
	
	/**
	 * 设置用户id
	 *
	 * @param int $v
	 * @return PwPhotoCommentDm
	 */
	public function setCreatedUid($v) {
		$this->_data['created_uid'] = $v;
		return $this;
	}
	
	/**
	 * 设置创建时间
	 *
	 * @param int $v
	 * @return PwPhotoCommentDm
	 */
	public function setCreatedTime($v) {
		$this->_data['created_time'] = $v;
		return $this;
	}
	
	/**
	 * 设置用户名
	 *
	 * @param int $v
	 * @return PwPhotoCommentDm
	 */
	public function setCreatedUsername($v) {
		$this->_data['created_username'] = $v;
		return $this;
	}
	
	/**
	 * 设置内容
	 *
	 * @param string $v
	 * @return PwPhotoCommentDm
	 */
	public function setContent($v) {
		$this->_data['content'] = trim($v);
		return $this;
	}
	
	/* (non-PHPdoc)
	 * @see PwBaseDm::_beforeAdd()
	 */
	protected function _beforeAdd() {
		if (empty($this->_data['photoid'])) return new PwError('PHOTO:photoid.empty');
		if (empty($this->_data['content']) || Pw::strlen($this->_data['content']) > 140) return new PwError('PHOTO:comment.content.illegal');
		if ($this->_filter()->filter($this->_data['content'])) return new PwError('PHOTO:comment.content.filter.fail');
		$this->_data['created_time'] = Pw::getTime();
	}

	/* (non-PHPdoc)
	 * @see PwBaseDm::_beforeUpdate()
	 */
	protected function _beforeUpdate() {
		// TODO Auto-generated method stub
		
	}
	
	/**
	 * @return PwWordFilter
	 */
	private function _filter() {
		Wind::import('SRV:word.srv.PwWordFilter');
		return PwWordFilter::getInstance();
	}

}

?>