<?php
/**
 * 照片模型
 *
 * @author Shi Long <long.shi@alibaba-inc.com>
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwPhotoDm.php 15668 2012-08-10 02:50:32Z long.shi $
 * @package photo.dm
 */
class PwPhotoDm extends PwBaseDm {
	
	public $photoid;
	
	/**
	 * 设置照片id
	 *
	 * @param int $v
	 * @return PwPhotoDm
	 */
	public function setPhotoid($v) {
		$this->photoid = $v;
		return $this;
	}
	
	/**
	 * 设置相册id
	 *
	 * @param int $v
	 * @return PwPhotoDm
	 */
	public function setAlbumid($v) {
		$this->_data['albumid'] = $v;
		return $this;
	}
	
	/**
	 * 设置是否缩略
	 *
	 * @param int $v
	 * @return PwPhotoDm
	 */
	public function setIfthumb($v) {
		$this->_data['ifthumb'] = $v;
		return $this;
	}
	
	/**
	 * 设置评论数
	 *
	 * @param int $v
	 * @return PwPhotoDm
	 */
	public function setCommentNum($v) {
		$this->_data['comment_num'] = $v;
		return $this;
	}
	
	/**
	 * 设置评论数
	 *
	 * @param int $v
	 * @return PwPhotoDm
	 */
	public function setIncreaseCommentNum($v) {
		$this->_increaseData['comment_num'] = $v;
		return $this;
	}
	
	/**
	 * 设置创建时间
	 *
	 * @param int $v
	 * @return PwPhotoDm
	 */
	public function setCreatedTime($v) {
		$this->_data['created_time'] = $v;
		return $this;
	}
	
	/**
	 * 设置名字
	 *
	 * @param string $v
	 * @return PwPhotoDm
	 */
	public function setName($v) {
		$this->_data['name'] = trim($v);
		return $this;
	}
	
	/**
	 * 设置图片路径
	 *
	 * @param string $v
	 * @return PwPhotoDm
	 */
	public function setPath($v) {
		$this->_data['path'] = $v;
		return $this;
	}
	
	/**
	 * 设置描述
	 *
	 * @param string $v
	 * @return PwPhotoDm
	 */
	public function setDescrip($v) {
		$this->_data['descrip'] = trim($v);
		return $this;
	}
	
	/* (non-PHPdoc)
	 * @see PwBaseDm::_beforeAdd()
	 */
	protected function _beforeAdd() {
		if (!isset($this->_data['albumid'])) return new PwError('PHOTO:albumid.empty');
		if (isset($this->_data['name']) && $this->_filter()->filter($this->_data['name'])) return new PwError('PHOTO:name.filter.fail');
		if (isset($this->_data['name']) && $this->_filter()->filter($this->_data['descrip'])) return new PwError('PHOTO:descrip.filter.fail');
		$this->_data['created_time'] = Pw::getTime();
	}

	/* (non-PHPdoc)
	 * @see PwBaseDm::_beforeUpdate()
	 */
	protected function _beforeUpdate() {
		if (!$this->photoid) return new PwError('PHOTO:id.empty');
		if (isset($this->_data['name']) && $this->_filter()->filter($this->_data['name'])) return new PwError('PHOTO:name.filter.fail');
		if (isset($this->_data['name']) && $this->_filter()->filter($this->_data['descrip'])) return new PwError('PHOTO:descrip.filter.fail');
	}
	
	/**
	 * @return PwWordFilter
	 */
	private function _filter() {
		Wind::import('SRV:word.srv.PwWordFilter');
		return PwWordFilter::getInstance();
	}

}

?>