<?php
/**
 * 后台搜索照片模型
 *
 * @author Shi Long <long.shi@alibaba-inc.com>
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwPhotoSo.php 10727 2012-05-29 09:30:47Z long.shi $
 * @package album.so
 */
class PwPhotoSo {
	protected $_data = array();
	
	/**
	 * 设置相册名
	 *
	 * @param string $name
	 * @return PwPhotoSo
	 */
	public function setAlbumName($name) {
		$this->_data['album'] = $name;
		return $this;
	}
	
	/**
	 * 设置作者名
	 *
	 * @param string $name
	 * @return PwPhotoSo
	 */
	public function setCreatedUsername($name) {
		$user = Wekit::load('user.PwUser')->getUserByName($name);
		$this->_data['created_uid'] = $user ? $user['uid'] : 0;
		return $this;
	}
	
	/**
	 * 设置照片名称
	 *
	 * @param string $name
	 * @return PwPhotoSo
	 */
	public function setPhotoname($name) {
		$this->_data['name'] = $name;
		return $this;
	}
	
	/**
	 * 设置描述
	 *
	 * @param string $descrip
	 * @return PwPhotoSo
	 */
	public function setDescrip($descrip) {
		$this->_data['descrip'] = $descrip;
		return $this;
	}
	
	/**
	 * 设置上传时间，根据时间区间
	 *
	 * @param int $min 区间左极限
	 * @return PwPhotoSo
	 */
	public function setMinUploadTime($min) {
		$this->_data['min'] = $min;
		return $this;
	}
	
	/**
	 * 设置上传时间，根据时间区间
	 *
	 * @param int $max 区间右极限
	 * @return PwPhotoSo
	 */
	public function setMaxUploadTime($max) {
		$this->_data['max'] = $max;
		return $this;
	}
	
	public function getData() {
		return $this->_data;
	}
}

?>