<?php
Wind::import('SRC:extensions.album.service.dm.PwAlbumDm');
Wind::import('SRC:extensions.album.service.bo.PwPhotoBo');
/**
 * 相册 服务
 *
 * @author Shi Long <long.shi@alibaba-inc.com>
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwAlbumService.php 18027 2012-09-11 03:14:08Z long.shi $
 * @package album.srv
 */
class PwAlbumService {

	/**
	 * 添加照片同时更新相册的照片数
	 *
	 * @param PwPhotoDm $dm
	 * @return PwError|boolean
	 */
	public function addPhoto(PwPhotoDm $dm) {
		$r = $this->_photoDs()->addPhoto($dm);
		if ($r instanceof PwError) return $r;
		$album = new PwAlbumDm();
		$album->setAlbumid($dm->getField('albumid'))->setIncreasePhotoNum(1);
		$this->_albumDs()->updateAlbum($album);
		return $r;
	}

	/**
	 * 添加照片评论同时更新评论数
	 *
	 * @param PwPhotoCommentDm $dm
	 * @return PwError|Ambigous <boolean, multitype:, number, rowCount>
	 */
	public function addPhotoComment(PwPhotoCommentDm $dm) {
		$r = $this->_photoCommentDs()->addComment($dm);
		if ($r instanceof PwError) return $r;
		$photo = new PwPhotoDm();
		$photo->setPhotoid($dm->getField('photoid'))->setIncreaseCommentNum(1);
		$this->_photoDs()->updatePhoto($photo);
		return $r;
	}
	
	/**
	 * 删除评论同时更新评论数
	 *
	 * @param int $commentid
	 * @param int $photoid
	 * @return boolean
	 */
	public function delPhotoComment($commentid, $photoid) {
		$this->_photoCommentDs()->delComment($commentid);
		$photo = new PwPhotoDm();
		$photo->setPhotoid($photoid)->setIncreaseCommentNum(-1);
		return $this->_photoDs()->updatePhoto($photo);
	}

	/**
	 * 删除照片同时更新照片数量
	 *
	 * @param int $photoid
	 * @return PwError|Ambigous <boolean, multitype:, number, rowCount>
	 */
	public function deletePhoto(PwPhotoBo $bo) {
		$this->_photoDs()->deletePhoto($bo->photoid);
		//删除图片
		Pw::deleteAttach($bo->info['path'], $bo->info['ifthumb']);
		
		$album = new PwAlbumDm();
		$album->setAlbumid($bo->info['albumid'])->setIncreasePhotoNum(-1);
		//若删除的是封面，改封面！
		if (trim($this->_getCover($bo->info['path'], $bo->info['ifthumb']), '/') == trim($bo->info['cover'], '/')) {
			$lastPhoto = $this->_photoDs()->getPhotoListByAlbumid($bo->info['albumid'], 1);
			$lastPhoto = current($lastPhoto);
			$cover = $lastPhoto ? $this->_getCover($lastPhoto['path'], $lastPhoto['ifthumb']) : '';
			$album->setCover($cover);
		}
		return $this->_albumDs()->updateAlbum($album);
	}

	/**
	 * 删除相册同时删除照片
	 *
	 * @param int $albumid
	 * @return boolean
	 */
	public function deleteAlbum($albumid) {
		if (0 >= ($albumid = intval($albumid))) return false;
		$photos = $this->_photoDs()->getPhotoListByAlbumid($albumid, PwPhotoBo::MAX_PHOTO_NUM);
		$result = $this->_photoDs()->deleteByAlbumid($albumid);
		//删除图片、相册
		if ($result) {
			foreach ($photos as $v) {
				Pw::deleteAttach($v['path'], $v['ifthumb']);
			}
			$result = $this->_albumDs()->deleteAlbum($albumid);
		}
		return $result;
	}

	/**
	 * 获取默认相册id，不存在则创建
	 *
	 */
	public function getDefaultAlbumidByType($uid, $type = PwAlbumDm::ALBUM_TYPE_ICON) {
		if (!in_array($type, array(PwAlbumDm::ALBUM_TYPE_DEFAULT, PwAlbumDm::ALBUM_TYPE_ICON))) return false;
		$default = $this->_albumDs()->getAlbumsByUidAndType($uid, $type);
		if (!$default) {
			/* @var $i18n WindLangResource */
			$i18n = Wind::getApp()->getComponent('i18n');
			list($m_icon, $m_default) = array($i18n->getMessage('PHOTO:album.icon'), $i18n->getMessage('PHOTO:album.default'));
			$iconDm = new PwAlbumDm();
			$iconDm->setCreatedUid($uid)->setName($m_icon)->setAlbumType(
				PwAlbumDm::ALBUM_TYPE_ICON)->setPrivacy(PwAlbum::PRIVACY_PUBLIC)->setDescrip($m_icon);
			$iconid = $this->_albumDs()->addAlbum($iconDm);
			
			$defaultDm = new PwAlbumDm();
			$defaultDm->setCreatedUid($uid)->setName($m_default)->setAlbumType(
				PwAlbumDm::ALBUM_TYPE_DEFAULT)->setPrivacy(PwAlbum::PRIVACY_PUBLIC)->setDescrip($m_default);
			$defaultid = $this->_albumDs()->addAlbum($defaultDm);
			
			$ids = array(
				PwAlbumDm::ALBUM_TYPE_ICON => $iconid, 
				PwAlbumDm::ALBUM_TYPE_DEFAULT => $defaultid);
			return $ids[$type];
		}
		return key($default);
	}

	/**
	 * @return PwAlbum
	 */
	private function _albumDs() {
		return Wekit::load('SRC:extensions.album.service.PwAlbum');
	}

	/**
	 * @return PwPhoto
	 */
	private function _photoDs() {
		return Wekit::load('SRC:extensions.album.service.PwPhoto');
	}

	/**
	 * @return PwPhotoComment
	 */
	private function _photoCommentDs() {
		return Wekit::load('SRC:extensions.album.service.PwPhotoComment');
	}

	/**
	 * @return PwPhotoJoin
	 */
	private function _photoJoinDs() {
		return Wekit::load('SRC:extensions.album.service.PwPhotoJoin');
	}
	
	private function _getCover($path, $ifthumb) {
		$dir = dirname($path);
		$file = basename($path);
		if ($ifthumb & 1) {$dir .= '/thumb';}
		return $dir . '/' . $file;
	}
}

?>