<?php
Wind::import('SRC:extensions.album.service.dm.PwAlbumDm');
Wind::import('SRC:extensions.album.service.dm.PwPhotoDm');
Wind::import('SRC:extensions.album.service.srv.upload.PwSavePhoto');
Wind::import('SRC:extensions.album.service.srv.upload.PwPhotoUpload');
/**
 * 上传头像同时上传头像相册
 *
 * @author Shi Long <long.shi@alibaba-inc.com>
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwPhotoUploadAvatarDo.php 15969 2012-08-16 08:51:42Z long.shi $
 * @package album.service.srv
 */
class PwPhotoUploadAvatarDo {

	/**
	 * 上传头像同时上传头像相册
	 *
	 * @param int $uid
	 * @return boolean
	 */
	public function uploadAvatar($uid) {
		if (!Wekit::config('SITE', 'album.isopen')) return false;
		$iconAlbumid = $this->_service()->getDefaultAlbumidByType($uid);
		$icon = ATTACH_PATH . 'avatar/' . Pw::getUserDir($uid) . "/$uid.jpg";
		if (!is_file($icon)) return false;
		$savePhoto = new PwSavePhoto(new PwPhotoUpload($uid, $iconAlbumid));
		$savePhoto->add($icon);
		$r = $savePhoto->execute();
		if ($r === true) {
			$album = $this->_albumDs()->getAlbum($iconAlbumid);
			if (!$album['cover']) {
				$dm = new PwAlbumDm();
				$photo = $savePhoto->getCurrentPhoto();
				$dm->setAlbumid($iconAlbumid)->setCover($this->_getCover($photo['fileuploadurl'], $photo['ifthumb']));
				$this->_albumDs()->updateAlbum($dm);
			}
			return true;
		}
		return false;
	}

	/**
	 * @return PwAlbumService
	 */
	private function _service() {
		return Wekit::load('SRC:extensions.album.service.srv.PwAlbumService');
	}
	
	/**
	 * @return PwAlbum
	 */
	private function _albumDs() {
		return Wekit::load('SRC:extensions.album.service.PwAlbum');
	}
	
	private function _getCover($path, $ifthumb) {
		$dir = dirname($path);
		$file = basename($path);
		if ($ifthumb & 1) {$dir .= '/thumb';}
		return $dir . '/' . $file;
	}
}

?>