<?php
Wind::import('SRV:forum.srv.post.do.PwPostDoBase');
Wind::import('SRC:extensions.album.service.srv.PwPhotoUpload');
Wind::import('SRV:upload.PwUpload');
Wind::import('SRC:extensions.album.service.dm.PwAlbumDm');
Wind::import('SRC:extensions.album.service.dm.PwPhotoDm');
/**
 * 帖子附件保存到默认相册
 *
 * @author Shi Long <long.shi@alibaba-inc.com>
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwPostDoAlbum.php 10826 2012-05-30 07:20:09Z long.shi $
 * @package album.service.srv
 */
class PwPostDoAlbum extends PwPostDoBase{
	
	private $uid;
	private $toAlbums;
	private $album;
	
	public function __construct(PwPost $pwpost, $toAlbums, $albumid) {
		$this->uid = $pwpost->user->uid;
		$this->toAlbums = $toAlbums;
		$this->album = $this->_albumDs()->getAlbum($albumid);
	}
	
	public function dataProcessing(PwPostDm $postDm) {
		if (!$this->album) return $postDm;
		/* @var $service PwThreadAttach */
		$service = Wekit::load('attach.PwThreadAttach');
		$attach = $service->getTmpAttachByUserid($this->uid);
		$photos = array();
		foreach ($attach as $rt) {
			if (!isset($this->toAlbums[$rt['aid']])) 
				continue;
			$dm = new PwPhotoDm();
			$dm->setAlbumid($this->album['albumid'])->setPath($rt['path'])->setIfthumb($rt['ifthumb']);
			$photos[] = $dm;
		}
		
		$count = count($photos);
		if ($this->album['photo_num'] + $count > Wekit::config('ALBUM', 'maxphoto'))
			return $postDm;
		//批量添加照片并更新相册照片数
		/* @var $photoService PwPhoto */
		$r = $this->_photoDs()->batchAddPhoto($photos);
		if (!$r instanceof PwError) {
			$dm = new PwAlbumDm();
			$dm->setAlbumid($this->album['albumid'])->setIncreasePhotoNum($count);
			$this->_albumDs()->updateAlbum($dm);
		}
		return $postDm;
	}
	
	/**
	 * @return PwAlbum
	 */
	private function _albumDs() {
		return Wekit::load('SRC:extensions.album.service.PwAlbum');
	}

	/**
	 * @return PwPhoto
	 */
	private function _photoDs() {
		return Wekit::load('SRC:extensions.album.service.PwPhoto');
	}

	/**
	 * @return PwAlbumService
	 */
	private function _service() {
		return Wekit::load('SRC:extensions.album.service.srv.PwAlbumService');
	}
}

?>