<?php
Wind::import('SRV:upload.action.PwUploadAction');
Wind::import('SRC:extensions.album.service.dm.PwAlbumDm');
Wind::import('SRC:extensions.album.service.dm.PwPhotoDm');
/**
 * 照片上传
 *
 * @author Shi Long <long.shi@alibaba-inc.com>
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwPhotoUpload.php 17340 2012-09-05 03:15:07Z long.shi $
 * @package upload.action
 */
class PwPhotoUpload extends PwUploadAction {
	public $ftype = array();
	public $ifftp = 0;
	public $attachs = array();
	private $uid;
	private $albumid;

	public function __construct($uid, $albumid) {
		$this->ftype = Wekit::config('ATTACHMENT', 'extsize');
		$this->uid = $uid;
		$this->albumid = $albumid;
	}

	/**
	 * 检测是否允许开始上传行为
	 *
	 * @return bool
	 */
	public function check() {
		$album = Wekit::load('SRC:extensions.album.service.PwAlbum')->getAlbum($this->albumid);
		if (!$album) return new PwError('PHOTO:album.exist.fail');
		
		return true;
	}

	/**
	 * 检测该条上传记录是否是为本次属于业务上传
	 *
	 * @param string $key
	 *        	$_FILES数组中的key
	 * @return bool
	 */
	public function allowType($key) {
		return true;
	}
	
	/*
	 * (non-PHPdoc) @see PwUploadAction::getSaveName()
	 */
	public function getSaveName(PwUploadFile $file) {
		$prename = substr(md5(Pw::getTime() . $file->id . WindUtility::generateRandStr(8)), 10, 15);
		$filename = $this->uid . "_$prename." . $file->ext;
		return $filename;
	}
	
	/*
	 * (non-PHPdoc) @see PwUploadAction::getSaveDir()
	 */
	public function getSaveDir(PwUploadFile $file) {
		return date('ym') . '/photo/';
	}

	/**
	 * 是否开启缩略图
	 *
	 * @return bool
	 */
	public function allowThumb() {
		return true;
		// return Wekit::config('attachment', 'thumb');
	}

	/**
	 * 缩略图生成配置
	 *
	 * @param string $filename
	 *        	文件名
	 * @param string $dir
	 *        	存储路径
	 * @return array 配置
	 *         例:array(
	 *         array(0.缩略图文件名, 1.缩略图存储地址, 2.限制宽, 3.限制高, 4.缩略图生成方式(*),
	 *         5.强制生成(*)),
	 *         array('abc.jpg', 'thumb/mini', 300, 300, 0, 0) 生成多个缩略图时，多条配置
	 *         )
	 *         (*4).缩略图生成方式 <0.等比缩略 1.居中截取 2.等比填充>
	 *         (*5).强制生成 <0.当文件尺寸小于缩略要求时，不生成 1.都生成>
	 */
	public function getThumbInfo($filename, $dir) {
		return array(
			array($filename, $dir . 'thumb/', 150, 150, 2), 
			array($filename, $dir . 'thumb/mini/', 90, 90, 2));
		/*
		 * $config = Wekit::config('attachment'); return array( array($filename,
		 * $dir . 'thumb/', $config['thumb.size.width'],
		 * $config['thumb.size.height'], $config['thumb']), array($filename,
		 * $dir . 'thumb/mini/', 200, 200, 1) );
		 */
	}

	/**
	 * 是否开启图片水印
	 *
	 * @return bool
	 */
	public function allowWaterMark() {
		return in_array('album', (array) Wekit::config('attachment', 'mark.markset'));
	}

	/* (non-PHPdoc)
	 * @see PwUploadAction::getWaterMarkInfo()
	 */
	public function getWaterMarkInfo() {
		$config = Wekit::load('config.PwConfig')->getValues('attachment');
		$info = array();
		foreach (array(
			'limitwidth', 
			'limitheight', 
			'position', 
			'gif', 
			'type', 
			'text', 
			'fontfamily', 
			'fontsize', 
			'fontcolor', 
			'quality', 
			'file', 
			'transparency', 
			'quality') as $k) {
			if (isset($config["mark.$k"])) $info[$k] = $config["mark.$k"];
		}
		return $info;
	}
	
	/*
	 * (non-PHPdoc) @see PwUploadAction::update()
	 */
	public function update($uploaddb) {
		/* @var $srv PwAlbumService */
		$srv = Wekit::load('SRC:extensions.album.service.srv.PwAlbumService');
		foreach ($uploaddb as $v) {
			$dm = new PwPhotoDm();
			$dm->setAlbumid($this->albumid)->setName(Pw::substrs($v['name'], 20, 0, false))->setPath(
				$v['fileuploadurl'])->setIfthumb($v['ifthumb']);
			$photoid = $srv->addPhoto($dm);
			if ($photoid instanceof PwError) return $photoid;
			$this->attachs[$photoid] = array(
				'photoid' => $photoid, 
				'name' => $v['name'], 
				'type' => $v['type'], 
				'path' => $v['fileuploadurl'], 
				'size' => $v['size'], 
				'descrip' => $v['descrip'], 
				'ifthumb' => $v['ifthumb']);
		}
		return true;
	}

	/**
	 * 获得上传附件列表
	 *
	 * @return array
	 */
	public function getAttachs() {
		return $this->attachs;
	}

	/**
	 * 获取上传的附件
	 *
	 * @return array
	 */
	public function getCurrentAttach() {
		$array = current($this->attachs);
		return array(
			'photoid' => $array['photoid'], 
			'path' => Pw::getPath($array['path'], $array['ifthumb'] & 2));
	}

	/**
	 * 获得上传附件个数
	 *
	 * @return int
	 */
	public function getUploadNum() {
		return count($this->attachs);
	}
}

?>