<?php
Wind::import('SRV:upload.PwUpload');
/**
 * 保存照片业务流程
 *
 * @author Shi Long <long.shi@alibaba-inc.com>
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwSavePhoto.php 10727 2012-05-29 09:30:47Z long.shi $
 * @package album.service.srv.upload
 */
class PwSavePhoto extends PwUpload {
	
	protected $upload;

	public function __construct(PwUploadAction $bhv) {
		$this->bhv = $bhv;
		$this->setStore();
	}
	
	/**
	 * 添加一张照片到相册
	 *
	 * @param string $src 照片路径
	 * @return boolean
	 */
	public function add($src) {
		if (!is_file($src)) return false;
		$file = new PwUploadFile();
		$file->ext = strtolower(substr(strrchr($src, '.'), 1));
		if (empty($file->ext) || !isset($this->bhv->ftype[$file->ext])) {
			return false;
		}
		$file->filename = $this->bhv->getSaveName($file);
		$file->savedir = $this->bhv->getSaveDir($file);
		$file->source = $this->store->getAbsolutePath($file->filename, $file->savedir);
		
		Wind::import('WIND:utility.WindFolder');
		WindFolder::mkRecur(dirname($file->source));
		
		//拷贝
		if (!copy($src, $file->source)) {
			return false;
		}
		$file->fileuploadurl = $file->savedir . $file->filename;
		//缩略
		$file->operateImage($this->bhv, $this->store);

		$this->upload[] = $file->getInfo();
		return true;
	}
	
	/**
	 * 获取当前照片
	 *
	 * @return mixed
	 */
	public function getCurrentPhoto() {
		return current($this->upload);
	}
	
	/* (non-PHPdoc)
	 * @see PwUpload::execute()
	 */
	public function execute() {
		return $this->bhv->update($this->upload);
	}
	
}

?>