<?php
defined('WEKIT_VERSION') || exit('Forbidden');

Wind::import('LIB:process.iPwGleanDoHookProcess');

/**
 * 新鲜事删除扩展服务接口--删除帖子源内容
 *
 * @author Jianmin Chen <sky_hold@163.com>
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwDeleteFreshDoTopicDelete.php 13278 2012-07-05 02:08:39Z jieyin $
 * @package forum
 */

class PwDeleteFreshDoTopicDelete extends iPwGleanDoHookProcess {
	
	public $record = array();
	
	public function gleanData($value) {
		if ($value['type'] == PwFresh::TYPE_THREAD_TOPIC) {
			$this->record[] = $value['src_id'];
		}
	}

	public function run($ids) {
		if ($this->record) {
			Wind::import('SRV:forum.srv.operation.PwDeleteTopic');
			Wind::import('SRV:forum.srv.dataSource.PwFetchTopicByTid');
			$srv = new PwDeleteTopic(new PwFetchTopicByTid($this->record), $this->srv->user);
			$srv->setIsDeleteFresh(false)
				->setIsDeductCredit($this->srv->isDeductCredit)
				->execute();
		}
	}
}