<?php
defined('WEKIT_VERSION') || exit('Forbidden');

Wind::import('LIB:process.iPwGleanDoHookProcess');

/**
 * 新鲜事删除扩展服务接口--删除微博源内容
 *
 * @author Jianmin Chen <sky_hold@163.com>
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwDeleteFreshDoWeiboDelete.php 8959 2012-04-28 09:06:05Z jieyin $
 * @package forum
 */

class PwDeleteFreshDoWeiboDelete extends iPwGleanDoHookProcess {
	
	public $record = array();
	
	public function gleanData($value) {
		if ($value['type'] == PwFresh::TYPE_WEIBO) {
			$this->record[] = $value['src_id'];
		}
	}

	public function run($ids) {
		if ($this->record) {
			Wind::import('SRV:weibo.srv.operation.PwDeleteWeibo');
			Wind::import('SRV:weibo.srv.dataSource.PwFetchWeiboById');
			$srv = new PwDeleteWeibo(new PwFetchWeiboById($this->record), $this->srv->user);
			$srv->execute();
		}
	}
}