<?php

/**
 * 类库加载工具
 *
 * the last known user to change this file in the repository  <$LastChangedBy: jieyin $>
 * @author Jianmin Chen <sky_hold@163.com>
 * @version $Id: PwLoader.php 13087 2012-06-28 10:15:38Z yishuo $
 * @package controller
 */
class PwLoader {
	protected static $_instances = array();
	protected static $_daoInstances = array();
	protected static $_daoMap = array();

	/**
	 * 加载类库(单例)
	 *
	 * @param string $path 路径
	 * return object
	 */
	public static function load($path) {
		strpos($path, ':') === false && $path = 'SRV:' . $path;
		if (!isset(self::$_instances[$path])) {
			$class = Wind::import($path);
			if (!class_exists($class)) {
				throw new PwException('class.path.fail', 
					array('{parm1}' => 'src.library.PwLoader.load', '{parm2}' => $class, '{parm3}' => $path));
			}
			self::$_instances[$path] = new $class();
		}
		return self::$_instances[$path];
	}

	/**
	 * 加载Dao(单例)
	 *
	 * @param string $path 路径
	 * return object
	 */
	public static function loadDao($path) {
		if (!isset(self::$_daoInstances[$path])) {
			self::$_daoInstances[$path] = self::getDao($path);
		}
		return self::$_daoInstances[$path];
	}

	/**
	 * 获取Dao组合(单例)
	 *
	 * @param int $index 索引键
	 * @param array $daoMap dao列表
	 * @param string $vkey 区分符
	 * return object
	 */
	public static function loadDaoFromMap($index, $daoMap, $vkey) {
		if (isset($daoMap[$index])) {
			return self::loadDao($daoMap[$index]);
		}
		$vkey .= '_' . $index;
		if (!isset(self::$_daoMap[$vkey])) {
			$instance = null;
			foreach ($daoMap as $key => $value) {
				if ($index & $key) {
					$baseInstance = $instance;
					$instance = self::getDao($value);
					if ($baseInstance) {
						$instance = clone $instance;
						$instance->setBaseInstance($baseInstance);
					}
				}
			}
			self::$_daoMap[$vkey] = $instance;
		}
		return self::$_daoMap[$vkey];
	}

	/**
	 * 加载Dao
	 *
	 * @param string $path 路径
	 * return object
	 */
	public static function getDao($path) {
		strpos($path, ':') === false && $path = 'SRV:' . $path;
		$class = Wind::import($path);
		if (!class_exists($class)) {
			throw new PwException('class.path.fail', 
				array('{parm1}' => 'src.library.PwLoader.getDao', '{parm2}' => $class, '{parm3}' => $path));
		}
		$daoInstance = new $class();
		$daoInstance->setDelayAttributes(array('connection' => array('ref' => 'db')));
		return $daoInstance;
	}
}