<?php
/**
 * P9中的一些全局挂载
 *
 * @author xiaoxia.xu <xiaoxia.xuxx@aliyun-inc.com>
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: PwFrontFilters.php 17149 2012-08-31 08:18:52Z long.shi $
 * @package wind
 */
class PwFrontFilters extends WindHandlerInterceptor {
	
	/* (non-PHPdoc)
	 * @see WindHandlerInterceptor::preHandle()
	 */
	public function preHandle($front = null) {
		$components = Wekit::config('components');
		if ($components) Wind::getApp()->getWindFactory()->loadClassDefinitions($components);
		$modules = Wekit::config('site', 'modules');
		if (isset($modules[Wind::getAppName()])) Wind::getApp()->setConfig(WindUtility::mergeArray(Wind::getApp()->getConfig(), array('modules' => $modules[Wind::getAppName()])));
		/* Wind::getApp()->getWindFactory()->loadClassDefinitions(
			array(
				'sqlStatement' => array('proxy' => 'WIND:filter.proxy.WindEnhancedClassProxy'), 
				'listeners' => array('LIB:compile.acloud.TestDbListener'))); */
		
		Wekit::createapp();
		//注册actionFilter
		/* @var $front WindWebFrontController */
		if ($filters = $this->getActionFilters(Wind::getAppName())) {
			$front->getApp()->registeActionFilter($filters);
		}
	}
	
	/* (non-PHPdoc)
	 * @see WindHandlerInterceptor::postHandle()
	 */
	public function postHandle() {
		if (!$posts = $this->getPost()) return;
		/* @var $chain WindHandlerInterceptorChain */
		$chain = WindFactory::createInstance('WindHandlerInterceptorChain');
		foreach ($posts as $key => $value) {
			$_compiler = Wind::import($value);
			$chain->addInterceptors(array($key => new $_compiler()));
		}
		$chain->getHandler()->handle();
	}

	/**
	 * @param string $appName
	 */
	protected function getActionFilters($appName) {
		//TODO  换成自动注册形式，不建议走文件
		$filters['admin'] = array(
			'global' => array('class' => 'LIB:filter.PwFilter'), 
			'default' => array(
				'class' => 'controller.filter.AdminDefaultFilter', 
				'pattern' => '~(appcenter/app/upload)'), 
			'csrf' => array('class' => 'LIB:filter.PwCsrfTokenFilter', 'pattern' => '~(appcenter/app/upload)'));
		
		$filters['phpwind'] = array(
			'global' => array('class' => 'LIB:filter.PwFilter'), 
			'csrf' => array(
				'class' => 'LIB:filter.PwCsrfTokenFilter', 
				'pattern' => '~(bbs/upload/*|windid/uploadAvatar/*|album/upload/run)'), 
			'autotask' => array('class' => 'APPS:task.filter.PwTaskFilter'), 
			'register' => array('class' => 'APPS:u.controller.filter.UserRegisterFilter', 'pattern' => 'u/register/*'));
		
		return isset($filters[$appName]) ? $filters[$appName] : array();
	}

	/**
	 * 返回当前注册的编译器
	 */
	protected function getPost() {
		return array('acloud' => 'LIB:compile.acloud.PwAcloudFilter');
	}
}