<?php
Wind::import('LIB:compile.acloud.PwAcloudDataMapper');

/**
 * Acloud服务相关
 *
 * @author xiaoxia.xu <xiaoxia.xuxx@aliyun-inc.com>
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: PwAcloudFilter.php 12957 2012-06-27 13:39:25Z liusanbian $
 * @package wekit.compile.acloud
 */
class PwAcloudFilter extends WindHandlerInterceptor {
	
	/* (non-PHPdoc)
	 * @see WindHandlerInterceptor::preHandle()
	 */
	public function preHandle() {
	}

	/* (non-PHPdoc)
	 * @see WindHandlerInterceptor::postHandle()
	 */
	public function postHandle() {
		if (Wind::getApp()->getRequest()->getIsAjaxRequest() || 'admin' == Wind::getAppName()) return;
		$_var = Wind::getApp()->getResponse()->getData('_aCloud_');
		if (in_array($_var['m'], array('design', 'cron', 'windid'))) return ;
		require_once Wind::getRealPath('ACLOUD:aCloud');
		$dataMapper = new PwAcloudDataMapper();
		if (null !== $collect = $this->getCollect($_var['c'])){
			if (!$collect->isCollect($_var['a'])) return;
			$vars = Wind::getApp()->getResponse()->getData($_var['current']);
			$collect->collect($dataMapper, $vars);
		}
		$dataMapper->setSrc($_var['c']);
		$dataMapper->setUid(PwUserBo::getLoginUser()->uid);
		$dataMapper->setUsername(PwUserBo::getLoginUser()->username);
		$dataMapper->setCharset(Wind::getApp()->getResponse()->getCharset());
		
		$this->getResponse()->setBody(ACloudAppGuiding::getApp($dataMapper), 'acloud');
	}
	
	/**
	 * 获得收集页面
	 *
	 * @return AbstractCollect
	 */
	private function getCollect($c) {
		$types = array();
		$types['read'] = 'LIB:compile.acloud.collect.PwAcloudReadCollect';
		$types['thread'] = 'LIB:compile.acloud.collect.PwAcloudThreadCollect';
		$types['index'] = 'LIB:compile.acloud.collect.PwAcloudIndexCollect';
		if (!$types[$c]) return null;
		$class = Wind::import($types[$c]);
		return new $class;
	}
}