<?php
Wind::import('WIND:viewer.AbstractWindTemplateCompiler');
/**
 * hook标签解析
 * 
 * 示例：
 * <code>
 * class MyClass {
 * public function plus($a, $b) {
 * echo $a + $b;
 * }
 * 
 * public static function myStatic() {
 * echo 'static';
 * }
 * }
 * $myclass = new MyClass();
 * 1、调用类中的方法可使用<hook name="plus" class="$myClass" method="plus" args = "array(1,2)" />
 * 2、调用类静态方法可使用<hook name="static" class="MyClass" method="mystatic" args = "array()" />
 * 或<hook name="static" method="myClass::mystatic" args="array()" />
 * 3、调用全局function可使用<hook name="G" method="func" args="array() "/>
 * </code>
 * 
 * @author Shi Long <long.shi@alibaba-inc.com>
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: PwTemplateCompilerHook.php 5606 2012-03-07 09:09:44Z xiaoxia.xuxx $
 * @package wekit
 * @subpackage engine.extension.viewer
 */
class PwTemplateCompilerHook extends AbstractWindTemplateCompiler {
	
	/**
	 * 调用的类名
	 */
	protected $class;
	
	/**
	 * 调用的方法名
	 */
	protected $method;
	
	/**
	 * @var string|array
	 */
	protected $args;
	
	/**
	 * 该钩子下所有钩子片段集中缓存的位置
	 * @var string
	 */
	protected $alias = '';
	
	/**
	 * 钩子名称
	 *
	 * @var string
	 */
	protected $name = 'hook';

	/* (non-PHPdoc)
	 * @see AbstractWindTemplateCompiler::compile()
	 */
	public function compile($key, $content) {
		if (!$this->method) return $content;
		if ($this->class)
			$callback = 'array(' . $this->class . ', "' . $this->method . '")';
		else
			$callback = '"' . $this->method . '"';
		if (!$this->args) {
			$this->args = 'array()';
		} else {
			$this->args = preg_replace('/\s*array\s*\(\s*/i', 'array(', $this->args);
			if (strpos($this->args, 'array(') === false) {
				$this->args = 'array(' . $this->args . ')';
			}
		}
		$this->args || $this->args = 'array()';
		$this->alias = trim($this->alias);
		$content = array();
		$content[] = '<?php';
		$content[] = 'PwHook::display("' . $this->name . '", ' . $callback . ',' . $this->args . ', "' . $this->alias . '", $__viewer);';
		$content[] = '?>';
		return implode("\r\n", $content);
	}

	/* (non-PHPdoc)
	 * @see AbstractWindTemplateCompiler::preCompile()
	 */
	public function preCompile() {
		$this->class = $this->method = $this->args = $this->name = '';
	}

	/* (non-PHPdoc)
	 * @see AbstractWindTemplateCompiler::getProperties()
	 */
	public function getProperties() {
		return array('class', 'method', 'args', 'name', 'alias');
	}

}

?>