<?php
Wind::import('Wind:viewer.AbstractWindTemplateCompiler');
/**
 * 编译模板标签
 * 
 * 支持属性:
 * source: 模板文件源地址
 * suffix: 模板文件后缀
 * load: 是否将编译内容加载到本模板中
 * theme: 调用当前哪种风格机制，有'site','space','area'等
 * <code><template source='' suffix='' load='false' theme='site'/></code>
 * 
 * @author Shi Long <long.shi@alibaba-inc.com>
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: PwTemplateCompilerTemplate.php 12077 2012-06-18 07:54:28Z long.shi $
 * @package library.engine.extension.viewer
 */
class PwTemplateCompilerTemplate extends AbstractWindTemplateCompiler {
	protected $source = '';
	protected $suffix = '';
	protected $load = 'true';
	protected $theme = '';
	
	/* (non-PHPdoc)
	 * @see AbstractWindTemplateCompiler::compile()
	 */
	public function compile($key, $content) {
		if (!$this->source) return $content;
		$oldWindView = $this->windViewerResolver->getWindView();
		if ($this->theme) {
			$newWindView = clone $oldWindView;
			switch (strtolower($this->theme)) {
				case 'site' :
					$newWindView->setTheme(Wekit::getGlobal('theme', 'theme') . '.template');
					break;
				case 'space' :
					$newWindView->setTheme('space.default.template');
					break;
				case 'area' :
					break;
				default : 
					$newWindView->setTheme($this->theme);
					break;
			}
			$this->windViewerResolver->setWindView($newWindView);
		}
		
		if ($this->load === 'false') {
			list($compileFile) = $this->windViewerResolver->compile($this->source, $this->suffix);
			$content = '<?php include("' . addslashes($compileFile) . '"); ?>';
		} else {
			list(, $content) = $this->windViewerResolver->compile($this->source, $this->suffix, true);
		}
		$this->theme && $this->windViewerResolver->setWindView($oldWindView);
		return $content;
	}

	/* (non-PHPdoc)
	 * @see AbstractWindTemplateCompiler::getProperties()
	 */
	public function getProperties() {
		return array('source', 'suffix', 'load', 'theme');
	}
}

?>