<?php
Wind::import('WIND:filter.WindActionFilter');
/**
 * 系统默认全局filter
 *
 * @author Qiong Wu <papa0924@gmail.com> 2011-12-2
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: PwFilter.php 17840 2012-09-10 05:21:44Z gao.wanggao $
 * @package src
 * @subpackage library.filter
 */
class PwFilter extends WindActionFilter {
	
	/* (non-PHPdoc)
	 * @see WindHandlerInterceptor::preHandle()
	 */
	public function preHandle() {
		/* 模板变量设置 */
		$url = array();
		$app = Wekit::app();
		$url['base'] = $app->baseUrl;
		$url['res'] = $app->res;
		$url['css'] = $app->css;
		$url['images'] = $app->images;
		$url['js'] = $app->js;
		$url['attach'] = $app->attach;
		$url['extres'] = $app->extres;
		$this->setGlobal($url, 'url');
	}
	
	/* (non-PHPdoc)
	 * @see WindHandlerInterceptor::postHandle()
	 */
	public function postHandle() {
		//门户管理模式 编译目录切换
		if ($this->getRequest()->getPost('design')) {
			$loginUser = PwUserBo::getLoginUser();
			$designPermission = $loginUser->getPermission('design_allow_manage');
			if ($designPermission['push'] > 1) {
				WindFolder::rm(Wind::getRealDir('DATA:design.template.'), true);
				$this->forward->getWindView()->compileDir = 'DATA:design.template.';
			}
		}
		
		// SEO settings
		Wind::import('SRV:seo.bo.PwSeoBo');
		$sitename = Wekit::config('site', 'info.name');
		PwSeoBo::set('{sitename}', $sitename);
		$seo = PwSeoBo::getData();
		
		$data = array();
		$data['version'] = WEKIT_VERSION;
		$data['seo'] = $seo;
		$this->setGlobal($data);
		
		$this->setOutput($this->getRequest()->getIsAjaxRequest() ? '1' : '0', '_ajax_');
		
		/*[设置给PwGlobalFilters需要的变量]*/
		$_var = array(
			'current' => $this->forward->getWindView()->templateName,
			'a' => $this->router->getAction(),
			'c' => $this->router->getController(),
			'm' => $this->router->getModule());
		$this->getResponse()->setData($_var, '_aCloud_');
	}
}
?>