<?php
 /**
  * 图片裁剪类
  * 
  * 功能：剪切   缩略 旋转
  * the last known user to change this file in the repository  <$LastChangedBy: gao.wanggao $>
  * @author $Author: gao.wanggao $ Foxsee@qq.com
  * @version $Id: PwCutImage.php 15355 2012-08-03 09:31:47Z gao.wanggao $ 
  * @package 
  */
 class PwCutImage {
	
	/**
	 * 需处理的文件，绝对路径
	 * 
	 * @var string
	 */
	public static $image;
	
	/**
	 * 处理后的图片大小
	 * 
	 * @var int
	 */
	public static $cutWidth = 0;
	
	public static $cutHeight = 0;
	
	/**
	 * 处理后的图片地址
	 * 
	 * @var string
	 */
	public static $outImage;
	
	/**
	 * 图片品质
	 * 
	 * @var int
	 */
	public static $quality = 90;
	
	/**
	 * 强制缩略图，空白填充
	 *
	 * @var bool
	 */
	public static $forceThumb = false;
	
	/**
	 * true剪切 false按比例缩小
	 *
	 * @var bool
	 */
	public static $forceScale = false;
	
	/**
	 * 图片剪切的左上角坐标
	 *
	 * @var int
	 */
	public static $cutX = 0;
	
	public static $cutY = 0;
	
	/**
	 * 旋转角度
	 * 
	 * @var int
	 */
	public static $degrees = 90;
	
	private static $_imageInfo;
	
	private static $_frontImage;
	
	private static $_backImage;
 	
	/**
	 * 图片剪切或缩略
	 * 
	 */
	public static function cut() {
		self::_getImageInfo();
		if (!self::$_imageInfo) return false;	
		$i_w = self::$_imageInfo[0];
		$i_h = self::$_imageInfo[1];
		$i_scale = $i_w / $i_h;

		if (!self::$cutWidth) {
			self::$cutWidth = self::$cutHeight * $i_scale;
		}
		
		if (!self::$cutHeight) {
			self::$cutHeight = self::$cutWidth / $i_scale;
		}
		
		$c_w = self::$cutWidth;
		$c_h = self::$cutHeight;
		
		$c_scale = $c_w / $c_h;
		
		if ($i_w < $c_w || $i_h < $c_h) {									//原图比缩略还小的，补白或返回原图
			$c_h = $i_h;
			$c_w = $i_w;
		} elseif (self::$forceScale) {										//裁剪
			if ($c_scale >= 1) {  //截宽
				if ($i_scale > 1 && $i_scale > $c_scale) { 					//宽截宽
					$_i_w = $i_w;
					$i_w = ($i_h /$c_h) * $c_w;
					self::$cutX = ($_i_w - $i_w) / 2;
				} else { 													//长截宽
					$i_h = ($i_w / $c_w)  * $c_h; 
					self::$cutX = 0;
				}
			} else {		//截长
				if ($i_scale < 1 && $i_scale < $c_scale) {  				//长截长
					$i_h = ($i_w / $c_w)  * $c_h; 
					self::$cutX = 0;
				} else {													//宽截长
					$_i_w = $i_w;
					$i_w = ($i_h /$c_h) * $c_w;
					self::$cutX = ($_i_w - $i_w) / 2;
				}
			}
		} else {															//缩略
			if ($i_scale > $c_scale) {
				$c_h = $c_w / $i_scale;
			} else { 						
				$c_w = $c_h * $i_scale;
			}

		}
		if (!self::$forceThumb) {											//强制补白
			self::$cutHeight = $c_h;
			self::$cutWidth = $c_w;
		}
		$offsetX = (self::$cutWidth - $c_w) / 2;
		$offsetY = (self::$cutHeight - $c_h) / 2;
		return self::_cutImage($c_w,$c_h,$i_w,$i_h, $offsetX, $offsetY);
	}
	
	/**
	 * 图片旋转
	 * 
	 */
	public function rotate() {
		self::_getImageInfo();
		if (self::$_imageInfo == false ) return false;	
		self::_creatFrontImage();
		$_color = imagecolorallocate(self::$_frontImage, 255, 255, 255);
		self::$_backImage = imagerotate(self::$_frontImage, self::$degrees, $_color);
		self::_creatImage();
		return true;
	}

	 	
	private static function _getImageInfo() {
		self::$_imageInfo = @getimagesize(self::$image);
	}

	private static function _isAnimate() {
		$_content = file_get_contents(self::$_frontImage);
		return  strpos($_content, 'NETSCAPE2.0') === false ?  false : true;
	}
	
	private static function _cutImage($cw,$ch,$iw,$ih, $offsetX = 0, $offsetY = 0) {
		self::_creatFrontImage();
		self::_creatBackImage();
		if (empty(self::$_frontImage) && empty(self::$_backImage)) return false;
		imagealphablending(self::$_backImage, true);
       	imagecolortransparent(self::$_backImage, imagecolorallocatealpha(self::$_backImage, 0, 0, 0, 0));
        imagecopyresampled(self::$_backImage, self::$_frontImage, $offsetX, $offsetY, self::$cutX,  self::$cutY, $cw, $ch, $iw, $ih);
		self::_creatImage();
		return true;
	}
	
	private static function _creatImage() {
		if (!self::_createFolder(dirname(self::$outImage))) return false;
		switch(self::$_imageInfo['mime']) {
			case 'image/jpeg':
				imagejpeg(self::$_backImage, self::$outImage, self::$quality);
				break;
			case 'image/gif':
				imagegif(self::$_backImage, self::$outImage);
				break;
			case 'image/png':
				imagepng(self::$_backImage, self::$outImage);
				break;
			default:
				return false;
		}
		imagedestroy(self::$_backImage);
		imagedestroy(self::$_frontImage);
	}
	
	private static function _creatFrontImage() {
		switch (self::$_imageInfo['mime']) {
			case 'image/jpeg':
				self::$_frontImage = imagecreatefromjpeg(self::$image);
				break;
			case 'image/gif':
				if (self::_isAnimate()) return false;
				self::$_frontImage = imagecreatefromgif(self::$image);
				break;
			case 'image/png':
				self::$_frontImage = imagecreatefrompng(self::$image);
				break;
			default:
				return false;
		}	
	}
	
	private static function _creatBackImage() {
		self::$_backImage = imagecreatetruecolor(self::$cutWidth, self::$cutHeight);
		$_tmp = imagecolorallocatealpha(self::$_backImage, 255, 255, 255, 0); 
		imagefill(self::$_backImage, 0, 0, $_tmp); 
	}
	
 	private static function _createFolder($path ='') {
		if (!is_dir($path)) {
           self::_createFolder(dirname($path));
           if (!@mkdir($path,0777)) return false;
           @touch($path."/index.html");
        }
		return true;
	}
 }
?>