<?php
defined('WEKIT_VERSION') || exit('Forbidden');

/**
 * Glean-Do(数据收集 - 操作)业务流程
 *
 * @author Jianmin Chen <sky_hold@163.com>
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwGleanDoProcess.php 7205 2012-03-30 11:25:47Z jieyin $
 * @package forum
 */

abstract class PwGleanDoProcess extends PwBaseHookService {
	
	protected function init() {

	}

	abstract public function getData();

	abstract protected function gleanData($value);
	
	abstract public function getIds();

	abstract protected function run();

	public function execute() {
		$this->init();
		foreach ($this->getData() as $key => $value) {
			$this->gleanData($value);
			$this->runDo('gleanData', $value);
		}
		if (($result = $this->run()) instanceof PwError) {
			return $result;
		}
		$this->runDo('run', $this->getIds());
		return true;
	}

	protected function _getInterfaceName() {
		return 'iPwGleanDoHookProcess';
	}
}