<?php
defined('WEKIT_VERSION') || exit('Forbidden');

Wind::import('LIB:utility.cachehandler.PwCacheHandler');

class PwCacheService{
	
	/**
	 * cache实例组
	 * 
	 * @var array
	 */
	private $_services = array();
	
	/**
	 * cache 策略
	 * 
	 * @var string STRATEGY_MEMCACHE|DB|FILE
	 */
	private $_cacheStrategy;
	
	/**
	 * 
	 * 当前cache实例组
	 * @var string
	 */
	private $_cacheModule;
	
	/**
	 * 
	 * 默认cache实例组
	 * @var string
	 */	
	//private $_defaultCacheModule = 'pwcache';
	const STRATEGY_AUTO = '_auto';
	const STRATEGY_FORCE = '_force';
	
	const STRATEGY_MEMCACHE = 'memcache';
	const STRATEGY_DBCACHE = 'db';
	const STRATEGY_FILECACHE = 'file';
	
	/**
	 * 
	 * Enter description here ...
	 * @param string $cacheModule 分组模块名
	 * @param string $cacheStrategy 缓存策略
	 */
	public function __construct($cacheModule = 'default',$cacheStrategy = self::STRATEGY_AUTO){
		$this->_cacheModule = $cacheModule;
		$this->_cacheStrategy = $cacheStrategy;
		$this->_initService();
	}
	
	public function set($key,$value,$expires = 0){
		return $this->_services[$this->_cacheModule]->set($key,$value,$expires);
	}
	
	public function get($key){
		return $this->_services[$this->_cacheModule]->get($key);
	}
	
	public function fetch(array $keys){
		return $this->_services[$this->_cacheModule]->batchGet($keys);
	}
	
	public function delete($key){
		return $this->_services[$this->_cacheModule]->delete($key);
	}
	
	public function batchDelete(array $keys){
		return $this->_services[$this->_cacheModule]->batchDelete($keys);
	}
	
	public function setCacheExpires($expires = 0) {
		$expires = intval($expires);
		foreach ($this->_services as $k=>$v) {
			$this->_services[$k]->setCacheExpires($expires);
		}
	}
	
	private function _initService(){
		//auto strategy
		if ($this->_cacheStrategy == self::STRATEGY_FORCE) {
			$cacheStrategy = $this->_getHighPerformanceStrategy();
			$config = $this->_getCacheConfig($cacheStrategy,$this->_cacheModule);
			if (!$config) {
				$cacheStrategy = self::STRATEGY_DBCACHE;
				$config = $this->_getCacheConfig($cacheStrategy,$this->_cacheModule);
				$this->_services[$this->_cacheModule] = $this->_getCache($cacheStrategy,$config);
			} else {
				$_previousCacheStrategy = self::STRATEGY_DBCACHE;
				$_previousCacheConfig = $this->_getCacheConfig($_previousCacheStrategy,$this->_cacheModule);
				$previousCache = $this->_getCache(self::STRATEGY_DBCACHE,$_previousCacheConfig);
				$cacheHandler = new PwCacheHandler();
				$cacheHandler->setPreviousCache($previousCache);
				$cache = $this->_getCache($cacheStrategy,$config);
				$cacheHandler->setCache($cache);
				$this->_services[$this->_cacheModule] = $cacheHandler;
			}
		//high performance strategy
		} else if ($this->_cacheStrategy == self::STRATEGY_AUTO){
			$cacheStrategy = $this->_getHighPerformanceStrategy();
			$config = $this->_getCacheConfig($cacheStrategy,$this->_cacheModule);
			if (!$config) {
				$cacheStrategy = self::STRATEGY_DBCACHE;
				$config = $this->_getCacheConfig($cacheStrategy,$this->_cacheModule);
			}
			$this->_services[$this->_cacheModule] = $this->_getCache($cacheStrategy,$config);
		} else {
			$cacheStrategy = $this->_cacheStrategy;
			$config = $this->_getCacheConfig($cacheStrategy,$this->_cacheModule);
			$this->_services[$this->_cacheModule] = $this->_getCache($cacheStrategy,$config);
		}
	}
	
	private function _getHighPerformanceStrategy(){
		return self::STRATEGY_MEMCACHE;
	}
	
	private function _getCacheConfig($cacheStrategy,$cacheModule = 'default'){
		$strategyConfig =  array(
			/*
			'memcache' => array(
				'default' => array(
					'servers' => array(
						'host1' => array('host'=>'127.0.0.1','port'=>11211)
					)
				),
				'user' => array(
					'servers' => array(
						'host1' => array('host'=>'127.0.0.1','port'=>11211),
						'host2' => array('host'=>'127.0.0.1','port'=>11211)
					)
				),
				'thread' => array(
					'servers' => array(
						'host1' => array('host'=>'127.0.0.1','port'=>11211),
						'host2' => array('host'=>'127.0.0.1','port'=>11211)
					)
				)
			),
			*/
			'db' => array(
				'default' => array(
					'table-name' => 'cache',
					'field-key' => 'cache_key',
					'field-value' => 'cache_value',
					'field-expire' => 'cache_expire'
				)
			),
			'file' => array(
				'default' => array(
					'dir' => 'DATA:data',
					'suffix' => 'txt',
					'dir-level' => '0'
				) 
			)
		);
		return $strategyConfig[$cacheStrategy][$cacheModule];
	}
	
	private function _getCache($cacheStrategy,$cacheConfig){
		switch ($cacheStrategy) {
			case self::STRATEGY_MEMCACHE:
				$type = 'mem';
			break;
			case self::STRATEGY_DBCACHE:
				$type = 'db';
			break;
			case self::STRATEGY_FILECACHE:
				$type = 'file';
			break;
			default:
				$type = null;
			break;
		}
		if (!$type) return null;
		$methodName = sprintf('_get%sCache',ucfirst($type));
		if (!method_exists($this, $methodName)) {
			return null;
		} else {
			$cacheInstance = $this->$methodName();
			$cacheConfig && $cacheInstance->setConfig($cacheConfig);
			return $cacheInstance;
		}
	}
	
	private function _getMemCache(){
		Wind::import("WIND:cache.strategy.WindMemCache");
		return new WindMemCache;
	}
	
	private function _getDbCache(){
		Wind::import("WIND:cache.strategy.WindDbCache");
		return new WindDbCache(Wind::getComponent('db'));
	}
	
	private function _getFileCache(){
		Wind::import("WIND:cache.strategy.WindFileCache");
		return new WindFileCache;
	}
}