<?php
/**
 * @author $Author: gao.wanggao $ Foxsee@qq.com
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwBaseUpload.php 3952 2012-02-03 07:33:06Z gao.wanggao $ 
 * @package 
 */

class PwBaseUpload {
	
	/**
	 * 允许上传的文件类型
	 * key为类型value为大小（不受$allowSize限制）的数组或用','分隔的类型（受$allowSize限制）
	 * @var string |array
	 */
	public static $allowExts;
	
	/**
	 * 
	 * 允许的上传大小(kB)
	 * @var int 
	 */
	public static $allowSize = 10240;
	
	public static $path = '';
	
	public static $folder;
	
	public static $outName;
	
	protected static $outMsg = array();
	
	protected static $tmpName;
	
	protected static $fileName;
	
	protected static $fileSize;
	
	protected static $realExt;
	
	protected static $error = array();
	
	protected static function setError($error='') {
		switch ($error) {
			case '1':
		   		self::$error = 'UPLOAD_ERR_INI_SIZE';
		    	break;
		    case '2':
		    	self::$error = 'UPLOAD_ERR_FORM_SIZE';
		    	break;
		    case '3':
		    	self::$error = 'UPLOAD_ERR_PARTIAL';
		    	break;
		    case '4':
		    	self::$error = 'UPLOAD_ERR_NO_FILE';
		    	break;
		    case '5':
		    	self::$error = 'UPLOAD_ERR_SIZE_IS_ZERO';
		    	break;
		    default:
		    	self::$error = $error;
		    	break;
		}   	
	}
	
	protected static function binFileList() {
		return array(
			'jpg'=>'FFD8FFE',
			'png'=>'89504E47',
			'gif'=>'47494638',
			'bmp'=>'424D7638',
			'xml'=>'3C3F786D6C',
			'doc'=>'D0CF11E0',
			'xls'=>'D0CF11E0',
			'ppt'=>'D0CF11E0',
			'docx'=>'504B030414',
			'xlsx'=>'504B030414',
			'pptx'=>'504B030414',
			'pdf'=>'255044462D312E',
			'zip'=>'504B0304',
			'rar'=>'52617221',
			'gz'=>'1F8B08',
			'tar'=>'1FA0',
			'7z' =>'377ABCAF271C',
			'wav'=>'57415645',
			'avi'=>'41564920',
			'rm'=>'2E524D46',
			'mov'=>'6D6F6F76',
			'asf'=>'3026B2758E66CF11',
			'mid'=>'4D546864',
			'mp3'=>'494433',		
		);
		
	}
	
	protected static function isAllowExt() {
		$exts = array();
		if (is_array(self::$allowExts)) {
			$exts =array_keys(self::$allowExts);
		} else {
			$exts = explode(',',self::$allowExts);
		}
		if (in_array(self::$realExt,$exts)) {
			return true;
		}
		self::setError('FILE_TYPE_NOT_ALLOW');
		return false;
		
	}
	
	protected static function isAllowSize() {
		if (is_array(self::$allowExts) && array_key_exists(self::$realExt, self::$allowExts) && self::$allowExts[self::$realExt]*1000 >= self::$fileSize) {
			return true;
		} elseif (in_array(self::$realExt,implode(',',self::$allowExts)) && self::$allowSize*1000 >= self::$fileSize){
			return true;
		} else {
			self::setError('FILE_SIZE_NOT_ALLOW');
			return false;
		}
	}
	
	protected static function isUploadFile() {
		if (!self::$tmpName || self::$tmpName == 'none') {
			return false;
		} elseif (is_uploaded_file(self::$tmpName) && is_uploaded_file(str_replace('\\\\', '\\', self::$tmpName))) {
			return true;
		} else {
			self::setError('FILE_NOT_UPLOAD');
			return false;
		}
	}
	
	protected static function setFolder() {
		if (!empty(self::$folder)) return;
		list($y, $m, $d) = explode('-', date('Y-m-d', Pw::getTime()));
		self::$folder = "$y/$m/$d/";
	}

	protected static function setFileName() {
		if (!empty(self::$outName)) {
			self::$outName .= '.'.self::$realExt;
		} else {
			self::$outName = time().mt_rand(1,100).'.'.self::$realExt;
		}
	}
	
	protected static function createFolder($path ='') {
		if (!file_exists($path)) {
           self::createFolder(dirname($path));
           if (!@mkdir($path,0777)) {
           	self::setError('FOLDER_IS_ERROR');
           	return false;
           }
        }
		return true;
	}
}
?>