<?php
 /**
 * the last known user to change this file in the repository  <$LastChangedBy: gao.wanggao $>
 * @author $Author: gao.wanggao $ Foxsee@qq.com
 * @version $Id: PwGDWaterMark.php 3897 2012-01-17 07:08:43Z gao.wanggao $ 
 * @package 
 */

class PwGDWaterMark {	
	
	/**
	 * 
	 * 需打水印的文件
	 * @var string
	 */
	public static $image;
	
	/**
	 * 
	 * 输出的文件
	 * @var string
	 */
	public static $outImage = '';
	/**
	 * 
	 * 水印类型  
	 * @var int 1.图片 2.文字
	 */
	public static $waterMarkType = 1;

	public static $position = 9;
	
	public static $limitWidth = 150;
	
	public static $limitHeight = 150;
	
	public static $isWaterMarkGif = false;
	
	public static $font = '';
	
	public static $text = 'PHPWIND';
	
	public static $size = 20;
	
	public static $color = 'FF0000';
	
	public static $trans = 40;
	
	public static $angle = 0;
	
	public static $quality = 100;
	
	public static $waterMarkFile;
	
	private static $_imageInfo = false;
	
	private static $_waterMarkInfo = false;
	
	private static $_waterImage;
	
	private static $_backImage;
	
	private static $_positionX = 0;
	
	private static $_positionY = 0;
	
	private static $_textW = 100;
	
	private static $_textH = 40;
	
	public static function waterMark() {
		self::_getImageInfo();
		if (self::_isWaterMark() == false ) return false;
		self::$waterMarkType == 2 ? self::_creatTextWaterMark() : self::_creatWaterMark();
		if (self::_creatBackImage() == false ) return false;
		self::_setImagesPosition();
		return self::_GDwaterMark();
	}
	
	private static function _getImageInfo() {
		self::$_imageInfo = @getimagesize(self::$image);
		if (self::$waterMarkType == 2) {
			self::_convert();
			$_fontArray = imagettfbbox(self::$size , self::$angle , self::$font ,  self::$text);
        	self::$_textW = $_fontArray[2]-$_fontArray[0] +20; 
			self::$_textH = $_fontArray[3]-$_fontArray[5] +5;
			self::$_waterMarkInfo = array('0'=>self::$_textW,'1'=>self::$_textH,'mime'=>'image/png');
		} else {
			self::$_waterMarkInfo =  @getimagesize(self::$waterMarkFile);
		}
	}
	
	private static function _isWaterMark() {
		if (!function_exists('imagecreatetruecolor') && !function_exists('imagecreatefromjpeg') ) return false;
		if (self::$_waterMarkInfo == false && self::$waterMarkType ==2) return false;
		if (self::$_imageInfo == false) return false;
		if (self::$_imageInfo[2] >= 3)  return false;
		if (self::$_imageInfo[2] == 1 && !$isWaterMarkGif)  return false;
		if (self::$_imageInfo[0] < self::$limitWidth && self::$_imageInfo[1] < self::$limitHeight) return false;
		if (self::$_imageInfo['mime'] == 'image/gif') {
			return self::_isAnimate();
		}
		return true;
	}
	
	private static function _isAnimate() {
		$_content = file_get_contents(self::$_waterImage);
		return  strpos($_content, 'NETSCAPE2.0') === false ?  false : true;
	}
	
	private static function _convert() {
		if (self::$text !== utf8_decode(utf8_encode(self::$text))) {
			self::$text = WindConvert::convert(self::$text, 'UTF-8', 'GBK');
		}
	}

	private static function _creatWaterMark() {
		switch (self::$_waterMarkInfo['mime']) {
			case 'image/jpeg':
				self::$_waterImage = imagecreatefromjpeg(self::$waterMarkFile);
				break;
			case 'image/gif':
				self::$_waterImage = imagecreatefromgif(self::$waterMarkFile);
				break;
			case 'image/png':
				self::$_waterImage = imagecreatefrompng(self::$waterMarkFile);
				break;
		}	
		if (self::$_waterImage) return true;
		return false;
	}
	
	private static function _creatBackImage() {
		switch (self::$_imageInfo['mime']) {
			case 'image/jpeg':
				self::$_backImage = imagecreatefromjpeg(self::$image);
				break;
			case 'image/gif':
				self::$_backImage = imagecreatefromgif(self::$image);
				break;
			case 'image/png':
				self::$_backImage = imagecreatefrompng(self::$image);
				break;
		}	
		if (self::$_backImage) return true;
		return false;
		
	}
	
	private static function _creatTextWaterMark() {
		if (empty(self::$font)) return false;
		list($r,$g,$b) = array(
            hexdec(substr(self::$color, 0, 2)),
            hexdec(substr(self::$color, 2, 2)),
            hexdec(substr(self::$color, 4, 2))
        );
		self::$_waterImage = imagecreatetruecolor(self::$_textW, self::$_textH);	
		imagesavealpha(self::$_waterImage, true);
		$tmp = imagecolorallocatealpha(self::$_waterImage,0,0,0,127); 
		imagefill(self::$_waterImage, 0, 0, $tmp);
		$color = imagecolorallocate(self::$_waterImage, $r, $g, $b);
		imagettftext(self::$_waterImage, self::$size, self::$angle, 20, 25, $color, self::$font, self::$text);
	}
	
	private static function _setImagesPosition() {
		$w_w = self::$_waterMarkInfo[0];
		$w_h = self::$_waterMarkInfo[1];
		$i_w = self::$_imageInfo[0];
		$i_h = self::$_imageInfo[1];
		$x = $y = 0;
		switch(self::$position) {
			case 1:
				$x = +5;
				$y = +5;
				break;
			case 2:
				$x = ($i_w - $w_w)/2;
				$y = +5;
				break;
			case 3:
				$x = $i_w - $w_w-5;
				$y = +5;
				break;
			case 4:
				$x = +5;
				$y = ($i_h - $w_h)/2;
				break;
			case 5:
				$x = ($i_w - $w_w)/2;
				$y = ($i_h - $w_h)/2;
				break;
			case 6:
				$x = $i_w - $w_w -5;
				$y = ($i_h - $w_h)/2;
				break;
			case 7:
				$x = 0;
				$y = $i_h - $w_h -5;
				break;
			case 8:
				$x = ($i_w - $w_w)/2;
				$y = $i_h - $w_h -5;
				break;
			case 9:
			default:
				$x = $i_w - $w_w-5;
				$y = $i_h - $w_h-5;
				break;
		}	
		self::$_positionX = $x;
		self::$_positionY = $y;
	}
	
	private static function _GDwaterMark() {
		if (function_exists('imagecopyresampled')) {//GD 2.01
			imagealphablending(self::$_backImage, true);
       	 	imagecolortransparent(self::$_backImage, imagecolorallocatealpha(self::$_backImage, 0, 0, 0,0));
        	imagecopyresampled(self::$_backImage, self::$_waterImage, self::$_positionX, self::$_positionY, 0, 0, self::$_waterMarkInfo[0],self::$_waterMarkInfo[1],self::$_waterMarkInfo[0],self::$_waterMarkInfo[1]);
		} else {
			imagecopymerge(self::$_backImage, self::$_waterImage, self::$_positionX, self::$_positionY, 0, 0, self::$_waterMarkInfo[0], self::$_waterMarkInfo[1], self::$trans);
		}
		if (empty(self::$outImage)) self::$outImage = self::$image;
        switch(self::$_imageInfo['mime']) {
			case 'image/jpeg':
				imagejpeg(self::$_backImage, self::$outImage, self::$quality);
				break;
			case 'image/gif':
				imagegif(self::$_backImage, self::$outImage, self::$quality);
				break;
			case 'image/png':
				imagepng(self::$_backImage, self::$outImage, self::$quality);
				break;
			default:
				return false;
		}
		imagedestroy(self::$_backImage);
		imagedestroy(self::$_waterImage);
		return true;
	}
	
	
}
?>