<?php
 /**
  * 图片编辑室类
  * 
  * the last known user to change this file in the repository  <$LastChangedBy: gao.wanggao $>
  * @author $Author: gao.wanggao $ Foxsee@qq.com
  * @version $Id: PwPicture.php 3897 2012-01-17 07:08:43Z gao.wanggao $ 
  * @package 
  */
 class PwPicture {
	
	/**
	 * 需处理的文件，绝对路径
	 * 
	 * @var string
	 */
	public static $image;
	
	/**
	 * 处理后的图片大小
	 * 
	 * @var int
	 */
	public static $cutWidth = 300;
	
	public static $cutHeight = 200;
	
	/**
	 * 处理后的图片地址
	 * 
	 * @var string
	 */
	public static $outImage;
	
	/**
	 * 图片品质
	 * 
	 * @var int
	 */
	public static $quality = 100;
	
	/**
	 * 强制缩略图，空白填充
	 *
	 * @var bool
	 */
	public static $forceThumb = false;
	
	/**
	 * true剪切 false按比例缩小
	 *
	 * @var bool
	 */
	public static $forceScale = false;
	
	/**
	 * 图片剪切的左上角坐标
	 *
	 * @var int
	 */
	public static $cutX = 0;
	
	public static $cutY = 0;
	
	/**
	 * 旋转角度
	 * 
	 * @var int
	 */
	public static $degrees = 90;
	
	private static $_imageInfo;
	
	private static $_frontImage;
	
	private static $_backImage;
 	
	/**
	 * 图片剪切和缩略
	 * 
	 */
	public static function cut() {
		self::_getImageInfo();
		if (!self::$_imageInfo) return false;	
		$i_w = self::$_imageInfo[0];
		$i_h = self::$_imageInfo[1];
		$c_w = self::$cutWidth;
		$c_h = self::$cutHeight;
		$i_scale = $i_w / $i_h;
		$c_scale = $c_w / $c_h;
		
		if ($i_w < $c_w && $i_h < $c_h) {
			$c_h = $i_h;
			$c_w = $i_w;
		} else if ($i_scale > $c_scale) {
			$c_h = $c_w / $i_scale;
		} else { 							// if($i_scale <= $c_scale) 
			$c_w = $c_h * $i_scale;
		}
		if (self::$forceScale) {
			$i_w = $c_w;
			$i_h = $c_h;
		}
		if (!self::$forceThumb) {
			self::$cutHeight = $c_h;
			self::$cutWidth = $c_w;
		}
		return self::_cutImage($c_w,$c_h,$i_w,$i_h);
	}
	
	/**
	 * 图片旋转
	 * 
	 */
	public function rotate() {
		self::_getImageInfo();
		if (self::$_imageInfo == false ) return false;	
		self::_creatFrontImage();
		$_color = imagecolorallocate(self::$_frontImage, 255, 255, 255);
		self::$_backImage = imagerotate(self::$_frontImage, self::$degrees, $_color);
		self::_creatImage();
		return true;
	}

	 	
	private static function _getImageInfo() {
		self::$_imageInfo = @getimagesize(self::$image);
	}

	private static function _isAnimate() {
		$_content = file_get_contents(self::$_frontImage);
		return  strpos($_content, 'NETSCAPE2.0') === false ?  false : true;
	}
	
	private static function _cutImage($cw,$ch,$iw,$ih) {
		self::_creatFrontImage();
		self::_creatBackImage();
		if (empty(self::$_frontImage) && empty(self::$_backImage)) return false;
		$offsetX = (self::$cutWidth - $cw) / 2;
		$offsetY = (self::$cutHeight - $ch) / 2;
		imagealphablending(self::$_backImage, true);
       	imagecolortransparent(self::$_backImage, imagecolorallocatealpha(self::$_backImage, 0, 0, 0, 0));
        imagecopyresampled(self::$_backImage, self::$_frontImage, $offsetX, $offsetY, self::$cutX,  self::$cutY, $cw, $ch, $iw, $ih);
		self::_creatImage();
		return true;
	}
	
	private static function _creatImage() {
		self::_createFolder( self::$outImage);
		switch(self::$_imageInfo['mime']) {
			case 'image/jpeg':
				imagejpeg(self::$_backImage, self::$outImage, self::$quality);
				break;
			case 'image/gif':
				imagegif(self::$_backImage, self::$outImage, self::$quality);
				break;
			case 'image/png':
				imagepng(self::$_backImage, self::$outImage, self::$quality);
				break;
			default:
				return false;
		}
		imagedestroy(self::$_backImage);
		imagedestroy(self::$_frontImage);
	}
	
	private static function _creatFrontImage() {
		switch (self::$_imageInfo['mime']) {
			case 'image/jpeg':
				self::$_frontImage = imagecreatefromjpeg(self::$image);
				break;
			case 'image/gif':
				if (self::_isAnimate()) return false;
				self::$_frontImage = imagecreatefromgif(self::$image);
				break;
			case 'image/png':
				self::$_frontImage = imagecreatefrompng(self::$image);
				break;
			default:
				return false;
		}	
	}
	
	private static function _creatBackImage() {
		self::$_backImage = imagecreatetruecolor(self::$cutWidth, self::$cutHeight);
		$_tmp = imagecolorallocatealpha(self::$_backImage, 0, 0, 0, 0); 
		imagefill(self::$_backImage, 0, 0, $_tmp); 
	}
	
 	private static function _createFolder($path ='') {
 		$path = dirname($path);
		if (!file_exists($path)) {
           self::_createFolder(dirname($path));
           if (!@mkdir($path,0777)) {
				return false;
           }
        }
		return true;
	}
 }
?>