<?php
Wind::import('LIB:utility.attachment.PwBaseUpload');
 /**
  * 普通上传处理类
  * 
  * the last known user to change this file in the repository  <$LastChangedBy: gao.wanggao $>
  * @author $Author: gao.wanggao $ Foxsee@qq.com
  * @version $Id: PwPostUpload.php 3897 2012-01-17 07:08:43Z gao.wanggao $ 
  * @package 
 */

class PwPostUpload extends PwBaseUpload{
	
	public static function upload() {
		self::_postFiles();
		return self::$outMsg;
	}
	
	private static function _getRealExt() {
		$binHeader = self::_getFileHeader();
		if (empty($binHeader)) {
			self::_setError('FILE_IS_ERROR');
			return false;
		}
		$inputExt = self::_getInputExt();
		$headArr = self::binFileList();
		if (array_key_exists($inputExt, $headArr)) {
			if (stripos($binHeader,$headArr[$inputExt])===0) {
				return $inputExt;
			} else {
				self::setError('FILE_TYPE_IS_ERROR');
				return false;
			}
		} else {
			self::setError('FILE_TYPE_NOT_ALLOW');
			return false;
		}
	}
	
	private static function _getInputExt() {
		return strtolower(substr(strrchr(self::$fileName, '.'), 1, 10));	
	}
	
	private static function _getFileHeader() {
		$content = file_get_contents(self::$tmpName);
		$binHeader = @unpack("H15", $content); 
		if (is_array($binHeader)) {
			if (!empty($binHeader[1])) {
				return $binHeader[1]; 
			}
		}
		return false;
	}
	
	private static function _postFiles() {
		self::$outMsg = array();
		if (empty($_FILES)) {
			self::setError(4);
			self::$outMsg[] = array('status'=>false, 'error'=>self::$error);
			return false;
		}
		foreach ($_FILES as $key => $value) {
			if (self::_execute($value)) {
				self::$outMsg[] = array('status'=>true, 'msg'=>'success', 'folder'=>self::$folder, 'name'=>self::$outName, 'size'=>self::$fileSize);
			} else {
				self::$outMsg[] = array('status'=>false, 'msg'=>self::$error);
			}
		}
	}
	
	private static function _execute($file) {
		self::$tmpName = $file['tmp_name'];
		self::$fileName = $file['name'];
		self::$fileSize = $file['size'];
		if ($file['error'] !== 0) {
			self::setError($file['error']);
			return false;
		}
		if (!self::isUploadFile()) return false;
		if ((self::$realExt = self::_getRealExt()) == false) return false;
		if (!self::isAllowExt()) return false;
		if (!self::isAllowSize()) return false;
		self::setFolder();
		self::setFileName();
		$_path = self::$path.self::$folder;
		$_filename = $_path.self::$outName;
		if (!self::createFolder($_path)) return false;
		if (function_exists("move_uploaded_file") && @move_uploaded_file(self::$tmpName, $_filename)) {
			@chmod($_filename, 0777);
			return true;
		} elseif (@copy(self::$tmpName, $_filename)) {
			@chmod($_filename, 0777);
			return true;
		} 
		self::setError('FILE_MOVE_ERROR');
		return false;
	}
	
}

?>