<?php

class PwCacheHandler{
	private $_cache;
	private $_previousCache;
	private $_cacheExpires = 0;

	public function __construct(){
		
	}
	
	public function set($key,$value,$expires = 0){
		if (!$key || !$this->_cache) {
			return false;
		}
		$this->_cacheExpires = intval($expires);
		$this->_previousCache && $this->_previousCache->set($key, $value, $this->_cacheExpires);
		return $this->_cache->set($key,$value,$this->_cacheExpires);
	}
	
	public function get($key,$callback = null,$callbackParams = array()){
		if (!$key || !$this->_cache) {
			return false;
		}
		$value = $this->_cache->get($key);
		if (false === $value) {
			if ($this->_previousCache) {
				$value = $this->_previousCache->get($key);
				$value !== false && $this->_cache->set($key,$value,$this->_cacheExpires);
			}
			if ($value === false && $callback) {
				$value = call_user_func_array($callback,$callbackParams);
				$this->_cache->set($key, $value, $this->_cacheExpires);
				$this->_previousCache && $this->_previousCache->set($key, $value, $this->_cacheExpires);
			}
		}
		return $value;
	}
	
	//TODO
	public function batchGet(array $keys){
		if (!$keys || !$this->_cache) {
			return false;
		}
		return $this->_cache->batchGet($keys);
	}
	
	public function delete($key){
		if (!$key || !$this->_cache) {
			return false;
		}
		return $this->_cache->delete($key);
		$this->_previousCache && $this->_previousCache->delete($key);
	}
	
	public function batchDelete(array $keys){
		if (!$keys || !$this->_cache) {
			return false;
		}
		return $this->_cache->batchDelete($keys);
		$this->_previousCache && $this->_previousCache->batchDelete($keys);
	}
	
	public function setCache($cache){
		$this->_cache = $cache;
	}
	
	public function setPreviousCache($cache){
		$this->_previousCache = $cache;
	}
		
	public function setCacheExpires($expires = 0) {
		$expires = intval($expires);
		$this->_cacheExpires = $expires;
	}
}