<?php
 /**
 * the last known user to change this file in the repository  <$LastChangedBy: gao.wanggao $>
 * @author $Author: gao.wanggao $ Foxsee@qq.com
 * @version $Id: PwBaseCode.php 17826 2012-09-10 03:51:53Z gao.wanggao $ 
 * @package 
 */
 class PwBaseCode {
	/**
	 * 验证码长度
	 * 
	 * @var int
	 */
	public static $verifyLength = 4;
	
	/**
	 * 1.数字 2.字母 3.数字+字母 4.汉字5.自定义问题
	 * 
	 * @var int
	 */
	public static $verifyType = 4;
	
	public static $verifyWidth = 240;
	
	public static $verifyHeight = 60;
	
	public static $isRandBackground = false;
	
	public static $isRandGraph = false;
	
	public static $isRandFont = false;
	
	public static $isRandSize = false;
	
	public static $isRandAngle = false;
	
	public static $isRandColor = false;
	
	public static $isRandGif = false;
	
	public static $isRandDistortion = false;
	
	public static $askCode = '';
	
	public static $answerCode = '';
	
	protected static $verifyCode = '';
	
	protected static $path = 'REP:';
	
	public static function getCode() {
		if (self::$verifyType == 5) return self::$answerCode;
		return strtolower(self::$verifyCode);
	}
	
	/**
	 * 设置验证码
	 * 
	 * @return void
	 */
	protected static function setRandCode() {
		switch (self::$verifyType) {
			case '1':
		   		$str = '1234567890';
		    	break;
		    case '2':
		   		$str = 'abcdefghjkmnpqrstuvwxyABCDEFGHJKLMNPQRSTUVWXY';
		    	break;
		    case '3':
		    default:
		   		$str = '3456789bcefghjkmpqrtvwxyzBCEFGHJKMPQRTVWXYZ';
		    	break;
		    case '4':
		   		$str = '人之初性本善性相近习相远苟不教性乃迁教之道贵以专昔孟母择邻处子不学断机杼窦燕山有义方教五子名俱扬养不教父之过教不严师之惰子不学非所宜幼不学老何为玉不琢不成器人不学不知义';
		   	 	break;
		    case '5':
		    	self::$verifyCode = self::_convert(self::$askCode);
		   		return true;
		    case '6': //目前只有这些声音文件
		    	$str = '123456789BCEFGHJKMPQRTVWXYZ';
		    	break;		
		}
	    $_tmp = WindString::strlen($str)-1;
	    $_num=0;
	    for($i = 0;$i < self::$verifyLength;$i++){
	        $_num = mt_rand(0, $_tmp);
	        $_code = WindString::substr($str, $_num, 1); 
	        self::$verifyCode .=  self::_convert($_code);
	    }
	}
	
 	private static function _convert($text='') {
		if ($text !== utf8_decode(utf8_encode($text))) {
			$text = WindConvert::convert($text, 'UTF-8', 'GBK');
		}
		return $text;
	}
	
 	/**
	 * 获取验证码背景文件
	 *
	 * @return array
	 */
	protected static function getVerifyBackground() {
		$_files = array();
		$_path = Wind::getRealDir(self::$path.'.bg.');
		$files = WindFolder::read($_path);
		foreach ($files AS $file) {
			if (is_file($_path .$file)) $_files[] = $_path .$file;
		}
		return $_files;
	}
	
	/**
	 * 获取字体列表
	 *
	 * @return array
	 */
	protected static function getFontList() {
		$_path=Wind::getRealDir(self::$path.'.font');
		return WindFolder::read($_path);
	}
	
	/**
	 * 获取英文字体列表
	 *
	 * @return array
	 */
	protected function getEnFontList() {
		$_fontList =array();
		$fontList = self::getFontList();
		foreach ($fontList AS $key=>$font) {
			if (strpos($font, 'en_')===0) {
				$_fontList[] = $font;
			}
		}
		return $_fontList;
	}
	
	/**
	 * 获取中文字体列表
	 *
	 * @return array
	 */
	protected static function getCnFontList() {
		$_fontList =array();
		$fontList = self::getFontList();
		foreach ($fontList AS $key=>$font) {
			if (strpos($font, 'cn_')===0) {
				$_fontList[] = $font;
			}
		}
		return $_fontList;
	}
	
 }
?>