<?php
defined('WEKIT_VERSION') || exit('Forbidden');

/**
 * @author Jianmin Chen <sky_hold@163.com>
 * @version $Id: phpwind.php 17125 2012-08-31 06:49:10Z long.shi $
 * @package wekit
 */
class phpwind {
	
	public $charset;	//程序编码
	public $version = '9.0 beta';

	public $timestamp;	//当前时间戳
	public $tdtime;		//当日零点时间戳

	public $baseUrl;	//网站地址
	public $res;		//res
	public $css;
	public $images;
	public $js;
	public $attach;
	public $themes;
	public $extres;

	public $clientIp;	//当前ip
	public $requestUri;
	public $lastRequestUri;
	public $lastvisit;
	public $user;

	public function __construct() {
		$this->charset = Wind::getApp()->getResponse()->getCharset();
		$this->clientIp = Wind::getApp()->getRequest()->getClientIp();
		$this->requestUri = Wind::getApp()->getRequest()->getRequestUri();

		$this->timestamp = time();//Pw::getTime();
		if ($cvtime = Wekit::config('site', 'time.cv')) $this->timestamp += $cvtime * 60;
		$this->tdtime = Pw::str2time(Pw::time2str($this->timestamp, 'Y-m-d'));
	}

	public function init() {
		$this->_initUrl();
		$this->_initUser();
		$this->runApps();
	}

	public function runApps() {
		$controller = Wind::getApp()->getComponent('router')->getController();
		require_once Wind::getRealPath ( 'ACLOUD:aCloud' );
		ACloudAppGuiding::runApps($controller);
	}
	
	public function cache() {

	}

	public function getLoginUser() {

	}

	protected function _initUrl() {
		$_consts = include (Wind::getRealPath('CONF:publish.php', true));
		foreach ($_consts as $const => $value) {
			if (defined($const)) continue;
			if ($const === 'PUBLIC_URL' && !$value) {
				$value = Wind::getApp()->getRequest()->getBaseUrl(true);
			}
			define($const, $value);
		}
		$this->baseUrl = PUBLIC_URL;
		$this->res = WindUrlHelper::checkUrl(PUBLIC_RES, $this->baseUrl);
		$this->css = WindUrlHelper::checkUrl(PUBLIC_RES . '/css/', $this->baseUrl);
		$this->images = WindUrlHelper::checkUrl(PUBLIC_RES . '/images/', $this->baseUrl);
		//$this->js = WindUrlHelper::checkUrl(PUBLIC_RES . '/js/' . (WIND_DEBUG ? 'dev/' : 'build/'), $this->baseUrl);
		$this->js = WindUrlHelper::checkUrl(PUBLIC_RES . '/js/' . 'dev/', $this->baseUrl);
		$this->attach = WindUrlHelper::checkUrl(PUBLIC_ATTACH, $this->baseUrl);
		$this->themes = WindUrlHelper::checkUrl(PUBLIC_THEMES, $this->baseUrl);
		$this->extres = WindUrlHelper::checkUrl(PUBLIC_THEMES . '/extres/', $this->baseUrl);
	}
	
	protected function _initUser() {
		$_cOnlinetime = Wekit::config('site', 'onlinetime') * 60;
		if ($lastvisit = Pw::getCookie('lastvisit')) {
			list($this->onlinetime, $this->lastvisit, $this->lastRequestUri) = explode("\t", $lastvisit);
			($onlinetime = $this->timestamp - $this->lastvisit) < $_cOnlinetime && $this->onlinetime += $onlinetime;
		} else {
			$this->onlinetime = 0;
			$this->lastvisit = $this->timestamp;
			$this->lastRequestUri = '';
		}
		$this->user = PwUserBo::getLoginUser();
		if ($this->user->isExists() && ($this->timestamp - $this->user->info['lastvisit'] > min(1800, $_cOnlinetime))) {
			Wind::import('SRV:user.dm.PwUserInfoDm');
			$dm = new PwUserInfoDm($this->user->uid);
			$dm->setLastvisit($this->timestamp)->setLastActiveTime($this->timestamp);
			if ($this->onlinetime > 0) {
				$dm->addOnline($this->onlinetime > $_cOnlinetime * 1.2 ? $_cOnlinetime : $this->onlinetime);
			}
			Wekit::load('user.PwUser')->editUser($dm, PwUser::FETCH_DATA);
			$this->onlinetime = 0;
		}
		Pw::setCookie('lastvisit', $this->onlinetime . "\t" . $this->timestamp . "\t" . $this->requestUri, 31536000);
	}
}