<?php

/**
 * 附件基础dao服务
 *
 * the last known user to change this file in the repository  <$LastChangedBy: jinling.sujl $>
 * @author Jianmin Chen <sky_hold@163.com>
 * @version $Id: PwThreadAttachDao.php 16698 2012-08-27 11:04:10Z jinling.sujl $
 * @package attach
 */

class PwThreadAttachDao extends PwBaseDao {
	
	protected $_table = 'attachs_thread';
	protected $_pk = 'aid';
	protected $_dataStruct = array('aid', 'fid', 'tid', 'pid', 'name', 'type', 'size', 'hits', 'width', 'height', 'path', 'ifthumb', 'special', 'cost', 'ctype', 'created_userid', 'created_time', 'descrip');
	
	public function getAttach($aid) {
		return $this->_get($aid);
	}

	public function fetchAttach($aids) {
		return $this->_fetch($aids);
	}

	public function getAttachByTid($tid, $pids) {
		$sql = $this->_bindSql('SELECT * FROM %s WHERE tid=? AND pid IN %s', $this->getTable(), $this->sqlImplode($pids));
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->queryAll(array($tid), 'aid');
	}

	public function getTmpAttachByUserid($userid) {
		$sql = $this->_bindTable("SELECT * FROM %s WHERE tid='0' AND pid='0' AND created_userid=?");
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->queryAll(array($userid), 'aid');
	}

	public function fetchAttachByTidAndPid($tids, $pids) {
		$sql = $this->_bindSql('SELECT * FROM %s WHERE tid IN %s AND pid IN %s', $this->getTable(), $this->sqlImplode($tids), $this->sqlImplode($pids));
		$rst = $this->getConnection()->query($sql);
		return $rst->fetchAll();
	}
	
	public function fetchAttachByTidsAndPid($tids,$pid) {
		$sql = $this->_bindSql('SELECT * FROM %s WHERE tid IN %s AND pid=?',$this->getTable(), $this->sqlImplode($tids));
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->queryAll(array($pid), 'aid');
	}

	public function addAttach($fields) {
		if (!isset($fields['aid']) || !$fields = $this->_filterStruct($fields)) {
			return false;
		}
		$sql = $this->_bindSql('INSERT INTO %s SET %s', $this->getTable(), $this->sqlSingle($fields));
		$this->getConnection()->execute($sql);
		return true;
	}
	
	public function updateAttach($aid, $fields, $increaseFields = array()) {
		return $this->_update($aid, $fields, $increaseFields);
	}

	public function batchUpdateAttach($aids, $fields, $increaseFields = array()) {
		return $this->_batchUpdate($aids, $fields, $increaseFields);
	}

	public function deleteAttach($aid) {
		return $this->_delete($aid);
	}
}