<?php
defined('WEKIT_VERSION') || exit('Forbidden');

/**
 * 配置管理
 *
 * @author Qiong Wu <papa0924@gmail.com> 2011-12-6
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwConfigBo.php 7431 2012-04-06 01:54:39Z jieyin $
 * @package src
 * @subpackage service.config.bo
 */
class PwConfigBo {

	protected $namespace = 'site';
	protected $config = array();

	/**
	 * @param string $namespace
	 */
	public function __construct($namespace = '') {
		$namespace && $this->namespace = $namespace;
	}

	/**
	 * 设置一个配置选项
	 *
	 * @param string $name 配置项
	 * @param mixed $value 配置值
	 * @param string $descrip 描述
	 * @return PwConfigBo
	 */
	public function set($name, $value, $descrip = null) {
		$this->config[$name] = array('name' => $name, 'value' => $value, 'descript' => $descrip);
		return $this;
	}

	/**
	 * 返回当前配置的值
	 * 
	 * @param string $name
	 */
	public function get($name) {
		return isset($this->config[$name]) ? $this->config[$name]['value'] : '';
	}

	/**
	 * 将数据持久化到数据库
	 */
	public function flush() {
		/* @var $service PwConfig */
		$service = Wekit::load('config.PwConfig');
		$service->setConfigs($this->namespace, $this->config);
	}

}
?>