<?php
defined('WEKIT_VERSION') || exit('Forbidden');

/**
 * 配置信息数据访问层
 * 
 * @author Jianmin Chen <sky_hold@163.com>
 * @license http://www.phpwind.com
 * @version $Id: PwConfigDao.php 14539 2012-07-24 01:47:48Z yishuo $
 * @package config
 */
class PwConfigDao extends PwBaseDao {

	protected $_table = 'common_config';

	/**
	 * 根据空间名字获得该配置信息
	 *
	 * @param stirng $namespace 空间名字
	 * @return array
	 */
	public function getConfig($namespace) {
		$sql = $this->_bindTable('SELECT * FROM %s WHERE namespace=?');
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->queryAll(array($namespace), 'name');
	}

	/**
	 * 获取某个配置
	 *
	 * @param string $namespace
	 * @param string $name
	 * @return array
	 */
	public function getConfigByName($namespace, $name) {
		$sql = $this->_bindTable('SELECT * FROM %s WHERE namespace=? AND name=?');
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->getOne(array($namespace, $name));
	}
	
	/**
	 * 批量设置配置项
	 *
	 * @param array $data 待设置的配置项
	 * @return boolean
	 */
	public function storeConfigs($data) {
		foreach ($data as $value) {
			$this->storeConfig($value['namespace'], $value['name'], $value['value']);
		}
		return true;
	}

	/**
	 * 存储配置项
	 * 
	 * @param string $namespace 配置项命名空间
	 * @param string $name 配置项名
	 * @param mixed $value 配置项的值
	 * @param string $descrip 配置项描述
	 * @return boolean
	 */
	public function storeConfig($namespace, $name, $value, $descrip = null) {
		$array = array();
		list($array['vtype'], $array['value']) = $this->_toString($value);
		isset($descrip) && $array['description'] = $descrip;
		if ($this->getConfigByName($namespace, $name)) {
			$sql = $this->_bindSql('UPDATE %s SET %s WHERE namespace=? AND name=?', $this->getTable(), $this->sqlSingle($array));
			$smt = $this->getConnection()->createStatement($sql);
			return $smt->update(array($namespace, $name));
		}
		$array['name'] = $name;
		$array['namespace'] = $namespace;
		$sql = $this->_bindSql('INSERT INTO %s SET %s', $this->getTable(), $this->sqlSingle($array));
		return $this->getConnection()->execute($sql);
	}

	/**
	 * 删除配置项
	 *
	 * @param string $namespace 配置项所属空间
	 * @return boolean
	 */
	public function deleteConfig($namespace) {
		$sql = $this->_bindTable('DELETE FROM %s WHERE namespace=?');
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->update(array($namespace));
	}

	/**
	 * 删除配置项
	 *
	 * @param string $namespace 配置项所属空间
	 * @param string $name 配置项名字
	 * @return boolean
	 */
	public function deleteConfigByName($namespace, $name) {
		$sql = $this->_bindTable('DELETE FROM %s WHERE namespace=? AND name=?');
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->update(array($namespace, $name));
	}

	/**
	 * 将数据转换为字符串
	 *
	 * @param mixed $value 待处理的数据
	 * @return array 返回处理后的数据，第一个代表该数据的类型，第二个代表该数据处理后的数据串
	 */
	private function _toString($value) {
		$vtype = 'string';
		if (is_array($value)) {
			$value = serialize($value);
			$vtype = 'array';
		} elseif (is_object($value)) {
			$value = serialize($value);
			$vtype = 'object';
		}
		return array($vtype, $value);
	}
}