<?php
defined('WEKIT_VERSION') || exit('Forbidden');

Wind::import('WINDID:service.config.bo.WindidCreditSet');

/**
 * 积分服务
 *
 * @author xiaoxia.xu <xiaoxia.xuxx@aliyun-inc.com>
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwCreditSetService.php 15879 2012-08-15 03:18:32Z xiaoxia.xuxx $
 * @package src.service.credit
 */
class PwCreditSetService {
	
	/**
	 * 获得设置的积分选项
	 *
	 * @return array
	 */
	public function getCredit() {
		Wind::import('WINDID:service.config.bo.WindidConfigBo');
		$config = WindidConfigBo::getInstance('credit');
		return $config->toArray();
	}

	/** 
	 * 设置用户积分
	 * 
	 * 算法步骤：
	 * 如果有新增的积分项（$newCredit）：（如果没有新增积分项，则直接跳转到步骤5）
	 * 1、先获取现有的数据表结构中的积分相关字段的列最大值 $maxCreditNum
	 * 2、根据最大的值获得积分区间 $creditRang(从1到$maxCreditNum)
	 * 3、根据现有传入的积分设置，和现有的最大区间得到差集，$freeDefaultCredit 该差集是目前区间内可用的积分项
	 * 4、扩展字段：（foreach）
	 * 4.1：如果在区间内没有可用的项，则下一个新增的积分项为目前最大积分项+1
	 * 4.2: 如果在区间内，则先采用区间内的值，从最小位开始补齐
	 * 4.2.1: 补齐的时候，判断如果该字段在表结构中已经存在，则不创建字段（1-8的字段不会被删除），否则创建字段
	 * 4.3： 将新的积分设置项和对应的新添加的字段关联，追加到creits中
	 * 5、将credits更新到设置
	 *
	 * @param array $credit 积分配置信息<array('1' => array('name'=>?,'unit'=>?,'descrip'=>?), '2' => ?, ...)>
	 * @param array $new 新增加的积分
	 * @return boolean
	 */
	public function setCredits($credits, $newCredit = array()) {
		if ($newCredit) {
			$struct = $this->_getDs()->getCreditStruct();
			$maxCreditNum = intval(str_replace('credit', '', max($struct)));
			$creditRang = range(1, $maxCreditNum, 1);
			$freeDefaultCredit = array_diff($creditRang, array_intersect($creditRang, array_keys($credits)));
			ksort($freeDefaultCredit);
			
			$next = 1;
			foreach ($newCredit as $id => $_item) {
				if (!$_item['name']) continue;
				$_new = 0;
				if (!$freeDefaultCredit) {
					$_new = $maxCreditNum + $next;
					if (!in_array('credit' . $_new, $struct)) {
						$this->_getDs()->alterAddCredit($_new);
					}
					$next ++;
				} else {
					$_new = array_shift($freeDefaultCredit);
					if (!in_array('credit' . $_new, $struct)) {
						$this->_getDs()->alterAddCredit($_new);
					}
				}
				$credits[$_new] = $_item;
			}
		}
		
		//更新windid的积分设置
		Wind::import('WINDID:service.config.dm.WindidConfigCreditDm');
		$dm = new WindidConfigCreditDm();
		$dm->setConfigs($credits);
		Windid::load('config.WindidConfig')->setConfigWithDm($dm);

		//更新本地的积分设置
		Wind::import('SRV:config.bo.PwConfigBo');
		$config = new PwConfigBo('credit');
		$config->set('credits', $credits)->flush();
		
		return true;
	}

	/** 
	 * 删除积分
	 * 
	 * 涉及更新：
	 * 1、windid上的积分设置
	 * 2、本地的积分设置
	 * 3、用户积分的相关字段设置
	 * 3.1: 如果积分字段在8以内则只是清楚该列数据，如果积分字段在8以上，删除对应字段
	 *
	 * @param int $creditId 积分ID
	 * @return PwError|boolean
	 */
	public function deleteCredit($creditId) {
		if ($creditId < 0) return new PwError("User:deleteCredit.illegal.creditId");
		//更新windid的设置
		Wind::import('WINDID:service.config.bo.WindidCreditSet');
		$configSet = new WindidCreditSet();
		$data = array($creditId . '.name', $creditId . '.unit', $creditId . '.descrip');
		foreach ($data as $configName) {
			$configSet->deleteConfigByName($configName);
		}
		
		//更新本地的设置
		/* @var $configService PwConfig */
		$configService = Wekit::load('config.PwConfig');
		$creditConfig = $configService->getConfigByName('credit', 'credits');
		$credits = unserialize($creditConfig['value']);
		unset($credits[$creditId]);
		Wind::import('SRV:config.bo.PwConfigBo');
		$config = new PwConfigBo('credit');
		$config->set('credits', $credits)->flush();
		
		//删除字段
		if ($creditId < 9) {
			$this->_getDs()->clearCredit($creditId);
		} else {
			$this->_getDs()->alterDropCredit($creditId);
		}
		
		return true;
	}
	
	/**
	 * 获取DS
	 *
	 * @return PwUserDataExpand
	 */
	private function _getDs() {
		return Wekit::load('user.PwUserDataExpand');
	}
}