<?php
/**
 * the last known user to change this file in the repository  <$LastChangedBy: gao.wanggao $>
 * @author $Author: gao.wanggao $ Foxsee@aliyun.com
 * @copyright ?2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwDesignStructureDm.php 18066 2012-09-11 05:42:29Z gao.wanggao $ 
 * @package 
 */
class PwDesignStructureDm extends PwBaseDm {

	
	public function setStructName($name) {
		$this->_data['struct_name'] = $name;
		return $this;
	}
	
	public function setStructTitle($array) {
		$this->_data['struct_title'] = serialize($array);
		return $this;
	}
	
	public function setStructStyle($font,$link,$border,$margin,$padding,$background,$styleclass) {
		$font['color'] = $this->_verifyColor($font['color']);
		$link['color'] = $this->_verifyColor($link['color']);
		$border['color'] = $this->_verifyColor($border['color']);
		$border['top']['color'] = $this->_verifyColor($border['top']['color']);
		$border['left']['color'] = $this->_verifyColor($border['left']['color']);
		$border['right']['color'] = $this->_verifyColor($border['right']['color']);
		$border['bottom']['color'] = $this->_verifyColor($border['bottom']['color']);
		$background['color'] = $this->_verifyColor($background['color']);
		
		if ($border['linewidth']) {
			$border['top']['linewidth'] = $border['linewidth'];
			$border['right']['linewidth'] = $border['linewidth'];
			$border['bottom']['linewidth'] = $border['linewidth'];
			$border['left']['linewidth'] = $border['linewidth'];
			unset($border['linewidth']);
			$border['isdiffer'] = 1;
		}
		
		if ($border['style']) {
			$border['top']['style'] = $border['style'];
			$border['right']['style'] = $border['style'];
			$border['bottom']['style'] = $border['style'];
			$border['left']['style'] = $border['style'];
			unset($border['style']);
		}
		
		if ($border['color']) {
			$border['top']['color'] = $border['color'];
			$border['right']['color'] = $border['color'];
			$border['bottom']['color'] = $border['color'];
			$border['left']['color'] = $border['color'];
			unset($border['color']);
		}
		
		if ($margin['both']) {
			$margin['top'] = $margin['both'];
			$margin['right'] = $margin['both'];
			$margin['bottom'] = $margin['both'];
			$margin['left'] = $margin['both'];
			unset($margin['both']);
			$margin['isdiffer'] = 1;
		}
		
		if ($padding['both']) {
			$padding['top'] = $padding['both'];
			$padding['right'] = $padding['both'];
			$padding['bottom'] = $padding['both'];
			$padding['left'] = $padding['both'];
			unset($padding['both']);
			$padding['isdiffer'] = 1;
		}
		
		$array = array(
			'font'=>$font,
			'link'=>$link,
			'border'=>$border,
			'margin'=>$margin,
			'padding'=>$padding,
			'background'=>$background,
			'styleclass'=>$styleclass
		);
		$this->_data['struct_style'] = serialize($array);
		return $this;
	}
	
	private function _verifyColor($v) {
		return (preg_match("/^#[a-z0-9]+$/",$v)) ? $v : ''; 
	}
	
	protected function _beforeAdd() {
		if (!$this->_data['struct_name']) return new PwError('fail');
		return true;
	}
	
	protected function _beforeUpdate() {
		if (!$this->_data['struct_name']) return new PwError('fail');
		return true;
	}
	
	
	
}
?>