<?php
/**
 * the last known user to change this file in the repository  <$LastChangedBy: gao.wanggao $>
 * @author $Author: gao.wanggao $ Foxsee@aliyun.com
 * @copyright ?2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwDesignExportZip.php 18165 2012-09-11 11:47:33Z gao.wanggao $ 
 * @package 
 */
class PwDesignExportZip {
	protected $dir = '';
	protected $pageid = 0;
	
	private $_tplExt = '.htm';
	private $_files = array();
	private $_moduleConf = array();
	
	public function __construct($pageid) {
		$this->pageid = $pageid;
		$this->dir = Wind::getRealDir('THEMES:portal.local.'). $pageid . '/';
	}
	
	public function zip() {
		Wind::import('LIB:utility.PwZip');
		$zip = new PwZip();
		$files = $this->read($this->dir);
		foreach ($files AS $k=>$v) {
			$files[$k]['filename'] = str_replace($this->dir, '', $v['filename']);
			if ($files[$k]['filename'] != 'template/index'.$this->_tplExt) continue;
			
			$files[$k]['data'] = $this->decompilePw($v['data']);
			$files[$k]['data'] = $this->decompileStruct($v['data']);
			$files[$k]['data'] = $this->decompileSegment($v['data']);
			$files[$k]['data'] = $this->decompileTpl($v['data']);
		}
		foreach ($files AS $file) {
			if (strtolower($file['filename']) == 'manifest.xml') {
				Wind::import("WIND:parser.WindXmlParser");
				$xml = new WindXmlParser();
				$config = $xml->parseXmlStream($file['data'], 0);
				$xml = new WindXmlParser();
				$config = array_merge($config, array('host'=>Wind::getApp()->getRequest()->getHostInfo()),$this->_moduleConf);
				$config = array('manifest'=>$config);
				$file['data'] = $xml->parseToXml($config);
			}
			$file['filename'] = 'phpwind9.0/'.$file['filename'];
			$zip->addFile($file['data'], $file['filename']);
		}
		return $zip->getCompressedFile();
	}
	
	protected function read($dir) {
		if (!$handle = @opendir($dir)) return array();
		while (false !== ($file = @readdir($handle))) {
			if ('.' === $file || '..' === $file) continue;
			$fileName = $dir . $file;
			if (is_dir($fileName .'/')) $this->read($fileName.'/');
			if (is_file($fileName)){
				if (!$_handle = fopen($fileName, 'rb')) continue;
				$data = '';
				while (!feof($_handle))
					$data .= fgets($_handle, 4096);
				fclose($_handle);
				$this->_files[] = array('filename'=>$fileName, 'data'=>$data);
			}
		}
		unset($data);
		@closedir($handle);
		return $this->_files;
	}
	
	protected function decompileTpl($section) {
		Wind::import("SRV:design.bo.PwDesignModuleBo");
		if(preg_match_all('/\<design\s*id=\"*D_mod_(\d+)\"*\s*role=\"*module\"*\s*[>|\/>]<\/design>/isU', $section, $matches)) {	
			foreach ($matches[1] AS $k=>$v) {
				$bo = new PwDesignModuleBo($v);
				$module = $bo->getModule();
				$property = $bo->getView();
				$_html = '<pw-list id="'.$k.'">';
				$_html .= $bo->getTemplate();
				$_html .= '</pw-list>';
				$section = str_replace($matches[0][$k], $_html, $section);
				$this->_moduleConf[$k] = array(
					'name'=>$module['module_name'],
					'model'=>$bo->getModel(), 
					'id'=>$v,
					'titlenum'=>strval($property['titlenum']),
					'desnum'=>strval($property['desnum']),
					'timefmt'=>$property['timefmt'],
					'limit'=>strval($property['limit']));
			}
		}
		return $section;
	}
	
	protected function decompilePw($section) {
		$in = array(
			'<design role="start"/>',
			'<!--# if($portal[\'header\']): #--><template source=\'TPL:common.header\' load=\'true\' /><!--# endif; #-->',
			'<!--# if($portal[\'navigate\']): #--><div class="bread_crumb">{@$headguide|html}</div><!--# endif; #-->',
			'<!--# if($portal[\'footer\']): #--><template source=\'TPL:common.footer\' load=\'true\' /><!--# endif; #-->',
			'<design role="end"/>',
		);
		$out = array(
			'<pw-start/>',
			'<pw-head/>',
			'<pw-navigate/>',
			'<pw-footer/>',
			'<pw-end/>',
		);
		return str_replace($in, $out, $section);
	}

	protected function decompileSegment($section) {
		$segment = $this->_getSegmentDs()->getSegmentByPageid($this->pageid);
		if(preg_match_all('/\<design\s*role=\"segment\"\s*id=\"(.+)\"[^>]+>/isU', $section, $matches)) {
			foreach ($matches[1] AS $k=>$v) {
				if (!$v) continue;
				if (isset($segment[$v])) {
					$section = str_replace($matches[0][$k], $segment[$v]['segment_struct'], $section);
				} else {
					$section = str_replace($matches[0][$k], '<pw-drag/>', $section);
				}
			}
		}
		return $section;
	}
	
	protected function decompileStruct($section) {
		$ds = Wekit::load('design.PwDesignStructure');
		if(preg_match_all('/\<design\s*role=\"title\"\s*id=\"(.+)\"[^>]+>/isU', $section, $matches)) {
			foreach ($matches[1] AS $k=>$v) {
				if (!$v) continue;
				$struct = $ds->getStruct($v);
				$_html = '<pw-title>';
				$_html .= unserialize($struct['struct_title']);
				$_html .= '</pw-title>';
				$section = str_replace($matches[0][$k], $_html, $section);
			}
		}
		return $section;
	}
	
	private function _getSegmentDs() {
		return Wekit::load('design.PwDesignSegment');
	}
}
?>