<?php
Wind::import('LIB:image.PwCutImage');
/**
 * the last known user to change this file in the repository  <$LastChangedBy: gao.wanggao $>
 * @author $Author: gao.wanggao $ Foxsee@aliyun.com
 * @copyright ?2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwDesignImage.php 15118 2012-07-31 08:20:40Z gao.wanggao $ 
 * @package 
 */
class PwDesignImage {
	protected $ftp = '';
	protected $moduleid = 0;
	protected $thumbW = 0;
	protected $thumbH = 0;
	protected $ext = '';
	protected $image = '';

	public function setInfo($moduleid, $image, $thumbW, $thumbH) {
		$this->moduleid = (int)$moduleid;
		$this->thumbW = (int)$thumbW;
		$this->thumbH = (int)$thumbH;
		$this->ext  = strtolower(substr(strrchr($image, '.'), 1));
		$this->image = $image;
	}
	
	public function setFtp($ftp = '') {
		$this->ftp = $ftp;
	}
	
	public function cut() {
		static $isDel = false;
		$outFile = $this->getFileName();
		$outDir = $this->getSaveDir();
		PwCutImage::$image = $this->getReadPath($outFile);
		PwCutImage::$outImage = Wind::getRealDir('PUBLIC:') . PUBLIC_ATTACH . $outDir.$outFile;
		PwCutImage::$cutWidth = $this->thumbW;
		PwCutImage::$cutHeight = $this->thumbH;
		PwCutImage::$quality = 90;
		PwCutImage::$forceThumb = true;
		PwCutImage::$forceScale = true;
		/*if (!$isDel){
			WindFolder::clear(Wind::getRealDir('PUBLIC:') . PUBLIC_ATTACH . $outDir, false);
			$isDel = true;
		}*/
		if (PwCutImage::cut()) {
			if ($this->ftp) {
				$this->ftp->upload($outDir.$outFile);
				WindFile::del(Wind::getRealDir('PUBLIC:') . PUBLIC_ATTACH . '/_tmp/' . $outFile);
				WindFile::del(Wind::getRealDir('PUBLIC:') . PUBLIC_ATTACH . '/' . $outDir.$outFile);
			}
			return Wekit::app()->attach . $outDir.$outFile;
		}
		return '';
	}
	
	protected function getReadPath($outFile) {
		if ($this->ftp) {
			$localname = Wind::getRealDir('PUBLIC:') . PUBLIC_ATTACH . '/_tmp/' . $outFile;
			$path = $this->ftp->download($this->image, $localname);
		} else {
			$path = Wind::getRealDir('PUBLIC:') . PUBLIC_ATTACH . '/' . $this->image;
		}
		return $path;
	}
	
	protected  function getFileName() {
		$num = 6;
		$filename = $this->thumbW .'_'. $this->thumbH.'_';
		$str = '0123456789abcdefghjkmnopqrstuvwxyABCDEFGHJKLMNOPQRSTUVWXY';
		$len = Pw::strlen($str)-1;
		for($i = 0; $i < $num; $i++){
		    $_num = mt_rand(0, $len);
		    $filename .= substr($str, $_num, 1); 
		}
		$filename .='.'.$this->ext;
		return $filename;
	}
	
	protected  function getSaveDir() {
		return '/module/'.$this->moduleid.'/';
	}
}
?>