<?php
/**
 * the last known user to change this file in the repository  <$LastChangedBy: gao.wanggao $>
 * @author $Author: gao.wanggao $ Foxsee@aliyun.com
 * @copyright ?2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwDesignImportZip.php 18165 2012-09-11 11:47:33Z gao.wanggao $ 
 * @package 
 */
class PwDesignImportZip {
	public $newIds = array();
	
	protected $themesPath = '';
	protected $pageid = 0;
	
	
	private $_tplExt = '.htm';
	private $_isOwn = false; //是否本域名
	
	public function __construct($pageid) {
		$this->pageid = $pageid;
		$this->themesPath = Wind::getRealDir('THEMES:portal.local.');
	}
	
	/**
	 * 检查目录
	 * Enter description here ...
	 */
	public function checkDirectory() {
		if (is_writable($this->themesPath)) return true;
		//$octal = substr(sprintf("%o",fileperms($this->themesPath)),-4);//TODO 后期修正is_writable的用户组权限
		return false;
	}
	
	public function checkZip($filename) {
		Wind::import("WIND:parser.WindXmlParser");
		Wind::import('LIB:utility.PwZip');
		$config = array();
		$_isTpl = false;
		$extension = array('htm','js','gif','jpg','jpeg','txt','png','css','xml');
		$zip = new PwZip();
		$xml = new WindXmlParser();
		if (!$fileData = $zip->extract($filename)) return new PwError("DESIGN:upload.file.error");
		foreach ($fileData AS &$file) {
			$file['filename'] = str_replace('\\', '/', $file['filename']);
			$pos = strpos($file['filename'], '/');
			$lenth = strlen($file['filename']);
			$file['filename'] = substr($file['filename'], (int)$pos+1, $lenth-$pos);
			if (strtolower($file['filename']) == 'manifest.xml') {
				$config = $xml->parseXmlStream($file['data'], 0);
				if (Wind::getApp()->getRequest()->getHostInfo() == $config['host']) $this->_isOwn = true;
			}
			//过滤文件类型
			$ext = strtolower(substr(strrchr($file['filename'], '.'), 1));
			if (!in_array($ext, $extension)) {
				unset($file); 
				continue;
			}
			
			//过滤中文文件名
			if (preg_match('/^[\x7f-\xff]+$/', $file['filename'])) {
				unset($file);
				continue;
			}
		}
		if (!$config) return new PwError("DESIGN:file.check.fail");
		foreach ($fileData AS &$_file) {
			if ($_file['filename'] != 'template/index'.$this->_tplExt) continue;
			$_file['data'] = $this->compileTitle($_file['data']);
			$_file['data'] = $this->compileTpl($_file['data']);
			$_file['data'] = $this->replaceTpl($_file['data'], $config);
			$_file['data'] = $this->compilePw($_file['data']);
			$_file['data'] = $this->compileDrag($_file['data']);
			if ($_file['data']) $_isTpl = true;
		}
		WindFile::del($filename);
		//TODO 版本号验证
		if (!$fileData) return new PwError("DESIGN:file.check.fail");
		if (!$_isTpl) return new PwError("DESIGN:file.check.fail");
		if (!$this->writeFile($fileData)) return true;
	}
	
	protected function compileTpl($section) {
		Wind::import('SRV:design.dm.PwDesignModuleDm');
		$ds = Wekit::load('design.PwDesignModule');
    	if (preg_match_all('/\<pw-list[>|\/>](.+)<\/pw-list>/isU',$section, $matches)) {
    		foreach ($matches[1] AS $k=>$v) {
    			//$v = trim($v);
    			$v = str_replace("	",'', trim($v));
	    		$name = 'section_' . WindUtility::generateRandStr(6);
	    		$dm = new PwDesignModuleDm();
	    		$dm->setPageId($this->pageid)
	    			->setFlag('thread')
	    			->setName($name)
	    			->setModuleTpl($v)
	    			->setModuleType(PwDesignModule::TYPE_IMPORT)
	    			->setIsused(1);
	    		$this->newIds[] = $moduleId = $ds->addModule($dm);
	    		if ($moduleId instanceof PwError)  continue;
	    		$_html = '<design id="D_mod_'.$moduleId.'" role="module" ></design>';
	    		$section = preg_replace('/\<pw-list[>|\/>](.+)<\/pw-list>/isU', $_html, $section, 1);
	    		//$section = str_replace('tmp_module_'.$moduleId, $_html, $section);
    		}
    	}
	    return $section;
	}
	
	protected function replaceTpl($section, $config) {
		Wind::import('SRV:design.dm.PwDesignModuleDm');
		$ds = Wekit::load('design.PwDesignModule');
    	if (preg_match_all('/\<pw-list\s*id=\"(\d+)\"\s*[>|\/>](.+)<\/pw-list>/isU',$section, $matches)) {
    		foreach ($matches[1] AS $k=>$v) {
    			$v = trim($matches[2][$k]);
    			//$v = str_replace("	",'', trim($v));
    			list($name, $model, $moduleid, $titlenum, $desnum,$timefmt,$limit) = $config['item'][$v];
    			!$model && $model = 'thread';
	    		$name = 'section_' . WindUtility::generateRandStr(6);
	    		$dm = new PwDesignModuleDm();
	    		$dm->setPageId($this->pageid)
	    			->setFlag($model)
	    			->setName($name)
	    			->setModuleTpl($v)
	    			->setProperty($titlenum, $desnum,$timefmt,$limit)
	    			->setModuleType(PwDesignModule::TYPE_IMPORT)
	    			->setIsused(1);
	    		$this->newIds[] = $moduleId = $ds->addModule($dm);
	    		if ($moduleId instanceof PwError)  continue;
	    		$_html = '<design id="D_mod_'.$moduleId.'" role="module"></design>';
	    		$section = preg_replace('/\<pw-list\s*id=\"(\d+)\"\s*[>|\/>](.+)<\/pw-list>/isU', $_html, $section, 1);
	    		
	    		//$section = str_replace($matches[0][$k], $_html, $section);
    		}
    	}
	    return $section;
	}
	
	protected function compileTitle($section) {
		Wind::import('SRV:design.dm.PwDesignStructureDm');
		$ds = Wekit::load('design.PwDesignStructure');
    	if (preg_match_all('/\<pw-title[>|\/>](.+)<\/pw-title>/isU',$section, $matches)) {
    		foreach ($matches[1] AS $k=>$v) {
    			$v = trim($v);
	    		$name = 'T_'.WindUtility::generateRandStr(6);
	    		$dm = new PwDesignStructureDm();
	    		$dm->setStructTitle($v)
	    			->setStructName($name);
	    		$resource = $ds->replaceStruct($dm);
	    		if ($resource instanceof PwError)  continue;
	    		$_html = '<design role="title" id="'.$name.'"/>';
	    		//$section = str_replace($matches[0][$k], $_html, $section);
	    		$section = preg_replace('/\<pw-title[>|\/>](.+)<\/pw-title>/isU', $_html, $section, 1);
    		}
    	}
	    return $section;
	}
	
	protected function compilePw($section) {
		$in = array(
			'<pw-start>',
			'<pw-head>',
			'<pw-navigate>',
			'<pw-footer>',
			'<pw-end>',
			'<pw-drag>'
		);
		$out = array(
			'<pw-start/>',
			'<pw-head/>',
			'<pw-navigate/>',
			'<pw-footer/>',
			'<pw-end/>',
			'<pw-drag/>'
		);
		$section = str_replace($in, $out, $section);
		$in = array(
			'<pw-start/>',
			'<pw-head/>',
			'<pw-navigate/>',
			'<pw-footer/>',
			'<pw-end/>',
		);
		$out = array(
			'<design role="start" pagename="portal"  unique="id"/>',
			'<!--# if($portal[\'header\']): #--><template source=\'TPL:common.header\' load=\'true\' /><!--# endif; #-->',
			'<!--# if($portal[\'navigate\']): #--><div class="bread_crumb">{@$headguide|html}</div><!--# endif; #-->',
			'<!--# if($portal[\'footer\']): #--><template source=\'TPL:common.footer\' load=\'true\' /><!--# endif; #-->',
			'<design role="end"/>',
		);
		return str_replace($in, $out, $section);
	}
	
	protected function compileDrag($section) {
		if (preg_match_all('/\<pw-drag\/>/isU',$section, $matches)) {
    		foreach ($matches[0] AS $k=>$v) {
    			$_html = '<design role="segment" id="'.WindUtility::generateRandStr(8).'"/>';
    			$section = preg_replace('/\<pw-drag\/>/isU', $_html, $section, 1);
    		}
		}
		return $section;
	}
	
	protected function writeFile($fileData) {
		$failArray = array();
		$dir = $this->themesPath . $this->pageid . '/';
		if (WindFolder::isDir($dir)) WindFolder::clear($dir, true);
		WindFolder::mk($dir);
		foreach ($fileData AS $file) {
			WindFolder::mkRecur($dir . dirname($file['filename']));
			if (!WindFile::write($dir . $file['filename'], $file['data'])) $failArray[] = $file['filename'];
		}
		return $failArray;
	}

}
?>